/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.CreateWaypointScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.WaypointListWidget;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WaypointScreen
extends AbstractBaseScreen {
    public WaypointListWidget waypointList;
    public PGImageButton addWaypoint;
    public PGImageButton backButton;
    public static ResourceLocation NEW_WAYPOINT_TEXTURES = PGHelper.id("textures/gui/sprites/icon/new_waypoint.png");

    public WaypointScreen() {
        super("menu.ricksportalgun.waypoints");
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null && this.minecraft.screen != null && this.minecraft.player != null);
        this.addWaypoint = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 + 68, this.height / 2 - 94, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.new"), button -> this.minecraft.setScreen((Screen)new CreateWaypointScreen()), 20, 20, NEW_WAYPOINT_TEXTURES));
        ItemStack stack = this.getItemStack();
        this.waypointList = (WaypointListWidget)this.addWidget((GuiEventListener)new WaypointListWidget(170, 152, this.width / 2 - 75, this.height / 2 - 70, 24, stack, true, 128, 20));
        this.backButton = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 140, this.height / 2 - 96, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.back"), button -> {
            SBOpenCoordGuiPacket packet = new SBOpenCoordGuiPacket();
            PGHelper.sendPacketToServer(packet);
        }, 20, 20, BACK_BUTTON_TEXTURE));
        PortalGunStyle style = this.getStyle();
        this.addWaypoint.setColor(style.highlightColor());
        this.addWaypoint.setRenderBackground(false);
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        this.waypointList.setRenderButtonBackground(false);
        this.waypointList.setStyle(style);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.translatable((String)"ricksportalgun.button.back"));
    }

    public void tick() {
        super.tick();
        assert (this.minecraft != null && this.minecraft.player != null);
        ItemStack heldItem = this.getItemStack();
        if (heldItem.is(PGTags.Items.PORTAL_GUNS)) {
            if (this.waypointList != null) {
                this.waypointList.refreshEntries(heldItem);
            }
        } else {
            this.onClose();
        }
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.fill(this.width / 2 - 154, this.height / 2 - 110, this.width / 2 + 165, this.height / 2 + 100, style.bgColor());
        GuiHelper.renderTooltip(graphics, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.new"), (AbstractWidget)this.addWaypoint);
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.addWaypoint, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.waypointList, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        if (this.waypointList != null) {
            this.waypointList.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.waypoint.saved"), this.width / 2, this.height / 2 - 92, style.textColor());
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, pMouseX, pMouseY, pPartialTick);
        }
        RenderSystem.enableBlend();
        graphics.blit(BG_LOCATION, this.width / 2 - 158, this.height / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }
}

