/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun.settings;

import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.client.entity.render.PortalEntityRenderer;
import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.settings.CustomizationSettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGSlider;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBColourPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class ColourPickingScreen
extends AbstractBaseScreen {
    private PGSlider r;
    private PGSlider g;
    private PGSlider b;
    private PGSlider size;
    private PGTextButton reset;
    private PGTextButton select;
    private PGTextButton cancel;
    private PGImageButton backButton;

    public ColourPickingScreen() {
        super((Component)Component.translatable((String)"menu.ricksportalgun.colour_select"));
    }

    protected void init() {
        assert (this.minecraft != null && this.minecraft.player != null);
        ItemStack stack = this.getItemStack();
        int color = (Integer)stack.getOrDefault(PGDataComponents.PORTAL_COLOUR, (Object)Color.GREEN.getRGB());
        this.r = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 44, this.height / 2 - 60, 36, 20, (Component)Component.empty(), new Color(color).getRed(), 0.0, 255.0, false));
        this.g = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 44, this.height / 2 - 36, 36, 20, (Component)Component.empty(), new Color(color).getGreen(), 0.0, 255.0, false));
        this.b = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 44, this.height / 2 - 12, 36, 20, (Component)Component.empty(), new Color(color).getBlue(), 0.0, 255.0, false));
        this.size = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 44, this.height / 2 + 12, 36, 20, (Component)Component.empty(), 1.0, 1.0, 3.0, false));
        this.select = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 136, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            if (stack.is(PGTags.Items.PORTAL_GUNS)) {
                SBColourPacket packet = new SBColourPacket(this.getColor());
                PGHelper.sendPacketToServer(packet);
                this.onClose();
            }
        }, this.font));
        this.cancel = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 8, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose(), this.font));
        this.reset = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 72, this.height / 2 + 42, 64, 20, (Component)Component.translatable((String)"ricksportalgun.button.colour.reset"), button -> {
            int rgb = (Integer)stack.getOrDefault(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)Color.GREEN.getRGB());
            try {
                this.r.setValue(new Color(rgb).getRed());
                this.g.setValue(new Color(rgb).getRed());
                this.b.setValue(new Color(rgb).getRed());
            }
            catch (Exception e) {
                PGConstants.LOGGER.warn(e.getMessage());
            }
        }, this.font));
        this.backButton = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 140, this.height / 2 - 96, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.back"), button -> this.minecraft.setScreen((Screen)new CustomizationSettingsScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        PortalGunStyle style = this.getStyle();
        this.select.setTextColour(style.textColor());
        this.reset.setTextColour(style.textColor());
        this.cancel.setTextColour(style.textColor());
        this.r.setRenderBG(false);
        this.g.setRenderBG(false);
        this.b.setRenderBG(false);
        this.size.setRenderBG(false);
        this.r.setStyle(style);
        this.g.setStyle(style);
        this.b.setStyle(style);
        this.size.setStyle(style);
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.translatable((String)"ricksportalgun.button.back"));
    }

    public int getColor() {
        try {
            return new Color((int)this.r.getValue(), (int)this.g.getValue(), (int)this.b.getValue()).getRGB();
        }
        catch (NumberFormatException e) {
            GuiHelper.drawWhiteCenteredString(new GuiGraphics(Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource()), (Component)Component.translatable((String)"error.ricksportalgun.color", (Object[])new Object[]{e.getMessage().toLowerCase()}), this.width / 2, 55);
            return 0;
        }
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.fill(this.width / 2 - 154, this.height / 2 - 110, this.width / 2 + 165, this.height / 2 + 100, style.bgColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.colour_select"), this.width / 2, this.height / 2 - 92, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.red", (Object[])new Object[]{""}), this.width / 2 - 110, this.r.getY() + 4, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.green", (Object[])new Object[]{""}), this.width / 2 - 110, this.g.getY() + 4, this.getStyle().textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.blue", (Object[])new Object[]{""}), this.width / 2 - 110, this.b.getY() + 4, this.getStyle().textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.settings.customization.color.size"), this.width / 2 - 110, this.size.getY() + 4, this.getStyle().textColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.reset, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        GuiHelper.renderWidgets(graphics, pMouseX, pMouseY, pPartialTick, new AbstractWidget[]{this.r, this.g, this.b});
        RenderSystem.enableBlend();
        graphics.blit(BG_LOCATION, this.width / 2 - 158, this.height / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        int x = 64;
        int y = 82;
        int multiplier = this.size.getValueInt();
        graphics.blit(PortalEntityRenderer.PORTAL_TEXTURE, this.width / 2 + 10, this.height / 2 - 64, 0, 0.0f, (float)(x * multiplier), y, x * multiplier, y, this.getColor());
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, pMouseX, pMouseY, pPartialTick);
        }
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.getFocused() instanceof Button) {
                    return super.keyPressed(pKeyCode, pScanCode, pModifiers);
                }
                SBColourPacket packet = new SBColourPacket(this.getColor());
                PGHelper.sendPacketToServer(packet);
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

