/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun.settings;

import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.settings.CustomizationSettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGSlider;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetPortalGunStylePacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;

public class ThemeEditScreen
extends AbstractBaseScreen {
    private PGTextButton select;
    private PGTextButton cancel;
    private PGSlider rText;
    private PGSlider gText;
    private PGSlider bText;
    private PGSlider rH;
    private PGSlider gH;
    private PGSlider bH;
    private PGSlider rBG;
    private PGSlider gBG;
    private PGSlider bBG;
    private PGImageButton backButton;

    public ThemeEditScreen() {
        super((Component)Component.translatable((String)"menu.ricksportalgun.settings.customization.theme"));
    }

    public void init() {
        super.init();
        assert (this.minecraft != null);
        PortalGunStyle style = this.getStyle();
        this.rH = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 90, this.height / 2 + 8, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.red((int)style.highlightColor()), 0.0, 255.0, false));
        this.gH = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 90, this.height / 2 + 28, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.green((int)style.highlightColor()), 0.0, 255.0, false));
        this.bH = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 90, this.height / 2 + 48, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.blue((int)style.highlightColor()), 0.0, 255.0, false));
        this.rText = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 18, this.height / 2 + 8, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.red((int)style.textColor()), 0.0, 255.0, false));
        this.gText = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 18, this.height / 2 + 28, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.green((int)style.textColor()), 0.0, 255.0, false));
        this.bText = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 - 18, this.height / 2 + 48, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.blue((int)style.textColor()), 0.0, 255.0, false));
        this.rBG = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 + 54, this.height / 2 + 8, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.red((int)style.bgColor()), 0.0, 255.0, false));
        this.gBG = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 + 54, this.height / 2 + 28, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.green((int)style.bgColor()), 0.0, 255.0, false));
        this.bBG = (PGSlider)this.addRenderableWidget((GuiEventListener)new PGSlider(this.width / 2 + 54, this.height / 2 + 48, 36, 12, (Component)Component.translatable((String)"chat.editBox"), FastColor.ARGB32.blue((int)style.bgColor()), 0.0, 255.0, false));
        this.select = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 136, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            SBSetPortalGunStylePacket packet = new SBSetPortalGunStylePacket(new PortalGunStyle(this.getHighlightColor(), this.getBackgroundColor(), this.getTextColor()));
            PGHelper.sendPacketToServer(packet);
            this.onClose();
        }, this.font));
        this.cancel = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 8, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose(), this.font));
        this.backButton = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 140, this.height / 2 - 96, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.back"), button -> this.minecraft.setScreen((Screen)new CustomizationSettingsScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        this.select.setTextColour(style.textColor());
        this.cancel.setTextColour(style.textColor());
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        this.doAll(pgSlider -> pgSlider.setStyle(style));
        this.doAll(pgSlider -> pgSlider.setRenderBG(false));
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.translatable((String)"ricksportalgun.button.back"));
    }

    private void doAll(Consumer<PGSlider> function) {
        function.accept(this.rH);
        function.accept(this.gH);
        function.accept(this.bH);
        function.accept(this.rBG);
        function.accept(this.gBG);
        function.accept(this.bBG);
        function.accept(this.rText);
        function.accept(this.gText);
        function.accept(this.bText);
    }

    private int getTextColor() {
        try {
            return FastColor.ARGB32.color((int)((int)this.rText.getValue()), (int)((int)this.gText.getValue()), (int)((int)this.bText.getValue()));
        }
        catch (Exception e) {
            PGConstants.LOGGER.warn(e.getMessage());
            return 0;
        }
    }

    private int getHighlightColor() {
        try {
            return FastColor.ARGB32.color((int)((int)this.rH.getValue()), (int)((int)this.gH.getValue()), (int)((int)this.bH.getValue()));
        }
        catch (Exception e) {
            PGConstants.LOGGER.warn(e.getMessage());
            return 0;
        }
    }

    private int getBackgroundColor() {
        try {
            return FastColor.ARGB32.color((int)((int)this.rBG.getValue()), (int)((int)this.gBG.getValue()), (int)((int)this.bBG.getValue()));
        }
        catch (Exception e) {
            PGConstants.LOGGER.warn(e.getMessage());
            return 0;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PortalGunStyle style = this.getStyle();
        graphics.fill(this.width / 2 - 154, this.height / 2 - 110, this.width / 2 + 165, this.height / 2 + 100, style.bgColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.settings.customization.theme"), this.width / 2, this.height / 2 - 92, style.textColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.r"), this.rH.getX() - 16, this.rH.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.g"), this.gH.getX() - 16, this.gH.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.b"), this.bH.getX() - 16, this.bH.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.r"), this.rText.getX() - 16, this.rText.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.g"), this.gText.getX() - 16, this.gText.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.b"), this.bText.getX() - 16, this.bText.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.r"), this.rBG.getX() - 16, this.rBG.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.g"), this.gBG.getX() - 16, this.gBG.getY() + 5, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.b"), this.bBG.getX() - 16, this.bBG.getY() + 5, style.textColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.customization.highlight"), this.rH.getX() + this.rH.getWidth() / 2, this.rH.getY() - 16, style.textColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.customization.text"), this.rText.getX() + this.rText.getWidth() / 2, this.rText.getY() - 16, style.textColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"ricksportalgun.button.customization.background"), this.rBG.getX() + this.rBG.getWidth() / 2, this.rBG.getY() - 16, style.textColor());
        Style guiStyle = GuiHelper.getStyle(mouseX, mouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, mouseX, mouseY, delta);
        }
        RenderSystem.enableBlend();
        graphics.blit(BG_LOCATION, this.width / 2 - 158, this.height / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        graphics.fill(this.rH.getX(), this.rH.getY() - 22, this.rText.getX() + this.rText.getWidth() / 2, this.rH.getY() - 76, this.getHighlightColor());
        graphics.fill(this.rText.getX() + this.rText.getWidth() / 2, this.rText.getY() - 22, this.rBG.getX() + this.rBG.getWidth(), this.rBG.getY() - 76, this.getBackgroundColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.settings.customization.theme.example"), this.width / 2, this.height / 2 - 48, this.getTextColor());
        int width = this.rBG.getX() + this.rBG.getWidth() - this.rH.getX();
        int height = this.rH.getY() - 76 - this.rH.getY() + 22;
        graphics.renderOutline(this.rH.getX(), this.rH.getY() - 22, width, height, Color.BLACK.getRGB());
        super.render(graphics, mouseX, mouseY, delta);
    }
}

