/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class PGImageButton
extends AbstractButton {
    protected ResourceLocation texture;
    protected final int textureWidth;
    protected final int textureHeight;
    protected final Consumer<AbstractButton> onPress;
    protected boolean renderBg = true;
    protected int color = (this.active ? 0xFFFFFF : 0xA0A0A0) | Mth.ceil((float)(this.alpha * 255.0f)) << 24;

    public PGImageButton(int x, int y, int width, int height, Component message, Consumer<AbstractButton> onPress, int textureWidth, int textureHeight, ResourceLocation texture) {
        super(x, y, width, height, message);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.texture = texture;
        this.onPress = onPress;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setTexture(ResourceLocation location) {
        this.texture = location;
    }

    public void setRenderBackground(boolean renderBg) {
        this.renderBg = renderBg;
    }

    public void renderString(GuiGraphics graphics, Font textRenderer, int color) {
    }

    public void onPress() {
        if (this.active) {
            this.onPress.accept(this);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.active) {
            if (this.renderBg) {
                super.renderWidget(graphics, mouseX, mouseY, delta);
            }
            int i = this.getX() + (this.getWidth() / 2 - this.textureWidth / 2);
            int j = this.getY() + (this.getHeight() / 2 - this.textureHeight / 2);
            float r = (float)FastColor.ARGB32.red((int)this.color) / 255.0f;
            float g = (float)FastColor.ARGB32.green((int)this.color) / 255.0f;
            float b = (float)FastColor.ARGB32.blue((int)this.color) / 255.0f;
            float a = (float)FastColor.ARGB32.alpha((int)this.color) / 255.0f;
            graphics.setColor(r, g, b, a);
            graphics.blit(this.texture, i, j, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

