/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PGSlider
extends AbstractSliderButton {
    protected Component msg;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;
    private boolean renderBG = true;
    private PortalGunStyle style;

    public PGSlider(int x, int y, int width, int height, Component message, double currentValue, double minValue, double maxValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.msg = message;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.equal((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.updateMessage();
    }

    public PGSlider(int x, int y, int width, int height, Component message, double currentValue, double minValue, double maxValue, boolean drawString) {
        this(x, y, width, height, message, currentValue, minValue, maxValue, 0.1f, 0, drawString);
    }

    public void setRenderBG(boolean renderBG) {
        this.renderBG = renderBG;
    }

    public void setStyle(PortalGunStyle style) {
        this.style = style;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.renderBG) {
            super.renderWidget(graphics, mouseX, mouseY, delta);
        } else if (this.style != null) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.style.bgColor());
            graphics.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.style.highlightColor());
            int i = this.getX() + (int)(this.value * (double)(this.width - 8));
            graphics.renderOutline(i, this.getY(), 8, this.getHeight(), this.style.highlightColor());
            graphics.fill(i, this.getY(), i + 8, this.getY() + this.getHeight(), this.style.highlightColor());
            int j = this.active ? 0xFFFFFF : 0xA0A0A0;
            this.renderScrollingString(graphics, Minecraft.getInstance().font, 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.value = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.updateMessage();
    }

    public String getValueString() {
        this.format.applyPattern("#.#");
        return this.format.format(this.getValue());
    }

    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.width - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.value;
        this.value = this.snapToNearest(value);
        if (!Mth.equal((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.clamp((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.lerp((double)Mth.clamp((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.clamp((double)value, (double)this.maxValue, (double)this.minValue) : Mth.clamp((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.map((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((Component)Component.empty().append(this.msg).append(this.getValueString()));
        } else {
            this.setMessage((Component)Component.empty());
        }
    }

    protected void applyValue() {
    }
}

