/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.block;

import com.jdolphin.ricksportalgun.common.blockentity.GunWorkbenchBlockEntity;
import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GunWorkbenchBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final MapCodec<GunWorkbenchBlock> CODEC = GunWorkbenchBlock.simpleCodec(GunWorkbenchBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public GunWorkbenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return GunWorkbenchBlock.createTickerHelper(type, PGBlockEntities.GUN_WORKBENCH, GunWorkbenchBlockEntity::tick);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        switch ((Direction)state.getValue(FACING)) {
            case NORTH: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.8125, (double)1.0, (double)1.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.75, (double)0.75, (double)1.0, (double)2.0, (double)1.0), (BooleanOp)BooleanOp.OR);
                break;
            }
            case WEST: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)1.0, (double)0.0, (double)0.9375, (double)1.75, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)1.75, (double)0.0, (double)1.0, (double)2.0, (double)1.0), (BooleanOp)BooleanOp.OR);
                break;
            }
            case SOUTH: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.0625, (double)1.0, (double)1.75, (double)0.1875), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.75, (double)0.0, (double)1.0, (double)2.0, (double)0.25), (BooleanOp)BooleanOp.OR);
                break;
            }
            case EAST: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)1.0, (double)0.0, (double)0.1875, (double)1.75, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.75, (double)0.0, (double)0.25, (double)2.0, (double)1.0), (BooleanOp)BooleanOp.OR);
            }
        }
        return Shapes.join((VoxelShape)this.makeBaseShape(), (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape makeBaseShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.75, (double)1.0, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.75, (double)0.25, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)0.25, (double)0.25), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof GunWorkbenchBlockEntity) {
            GunWorkbenchBlockEntity workbench = (GunWorkbenchBlockEntity)be;
            player.openMenu((MenuProvider)workbench);
        }
        return InteractionResult.SUCCESS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return PGBlockEntities.GUN_WORKBENCH.create(blockPos, blockState);
    }
}

