/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.block;

import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenBarrierGuiPacket;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubetherBarrierBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public SubetherBarrierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean flag;
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)ACTIVE), 2);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)ACTIVE), 2);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return SubetherBarrierBlock.simpleCodec(SubetherBarrierBlock::new);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PGHelper.sendPacketToClient((ServerPlayer)serverPlayer, (CustomPacketPayload[])new CBOpenBarrierGuiPacket[]{new CBOpenBarrierGuiPacket(pos)});
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return PGBlockEntities.SUBETHER_BARRIER.create(pos, state);
    }
}

