/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.blockentity;

import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import com.jdolphin.ricksportalgun.common.menu.workbench.SkinSelectorMenu;
import com.jdolphin.ricksportalgun.common.menu.workbench.WaypointTransferMenu;
import com.jdolphin.ricksportalgun.common.menu.workbench.WorkbenchCraftingMenu;
import com.jdolphin.ricksportalgun.common.recipe.PortalGunWorkbenchRecipe;
import com.jdolphin.ricksportalgun.common.recipe.WorkbenchRecipeInput;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GunWorkbenchBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    public static final String TAG_MODE = "WorkbenchMode";
    public static final String TAG_PROGRESS = "CraftProgress";
    private MenuType menuType = MenuType.CRAFTING;
    public static final int OUTPUT_SLOT = 4;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = PGHelper.seconds(3);
    private NonNullList<ItemStack> items = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);

    public GunWorkbenchBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(PGBlockEntities.GUN_WORKBENCH, pPos, pBlockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> GunWorkbenchBlockEntity.this.progress;
                    case 1 -> GunWorkbenchBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        GunWorkbenchBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        GunWorkbenchBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, Inventory inventory) {
        return this.menuType.fac.create(pContainerId, inventory, this, this.data, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.menuType = MenuType.values()[tag.getInt(TAG_MODE)];
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.progress = tag.getInt(TAG_PROGRESS);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt(TAG_MODE, this.menuType.ordinal());
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt(TAG_PROGRESS, this.progress);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        ((GunWorkbenchBlockEntity)t).baseTick(level, pos, state);
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void baseTick(Level level, BlockPos pos, BlockState state) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.setChanged();
            if (this.hasCraftingFinished() && this.craftItem()) {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private boolean craftItem() {
        Optional<RecipeHolder<PortalGunWorkbenchRecipe>> holder = this.getCurrentRecipe();
        if (holder.isPresent()) {
            PortalGunWorkbenchRecipe recipe = (PortalGunWorkbenchRecipe)holder.get().value();
            ItemStack output = recipe.getResult();
            ItemStack result = output.copy();
            ItemStack inOutputSlot = this.getItem(4);
            if (inOutputSlot.isEmpty()) {
                this.lowerInputs(recipe);
                this.setItem(4, result);
                return true;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)inOutputSlot, (ItemStack)result)) {
                int i = inOutputSlot.getCount();
                int j = result.getCount();
                result.setCount(i + j);
                this.lowerInputs(recipe);
                this.setItem(4, result);
                return true;
            }
            return false;
        }
        return false;
    }

    public void setMenuType(int i) {
        this.menuType = MenuType.values()[i];
    }

    private void lowerInputs(PortalGunWorkbenchRecipe recipe) {
        List<ItemStack> stacks = recipe.getInputs();
        for (ItemStack stack : stacks) {
            for (ItemStack invStack : this.items) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)invStack)) continue;
                int i = stack.getCount();
                int j = invStack.getCount();
                int result = Math.max(j - i, 0);
                invStack.setCount(result);
            }
        }
    }

    private void clearInputs() {
        for (int i = 0; i < 4; ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = PGHelper.seconds(3);
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<PortalGunWorkbenchRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack output = ((PortalGunWorkbenchRecipe)recipe.get().value()).getResult();
            return this.canPlaceItem(4, output);
        }
        return false;
    }

    private Optional<RecipeHolder<PortalGunWorkbenchRecipe>> getCurrentRecipe() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List recipeItems = this.items.subList(0, 4);
            return serverLevel.getRecipeManager().getRecipeFor(PGRecipeTypes.WORKBENCH_TYPE, (RecipeInput)new WorkbenchRecipeInput(recipeItems), (Level)serverLevel);
        }
        return Optional.empty();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.ricksportalgun.workbench");
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"menu.ricksportalgun.workbench");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public int getContainerSize() {
        return 10;
    }

    public static enum MenuType {
        WAYPOINT_TRANSFER(WaypointTransferMenu::new),
        SKIN_SELECTOR(SkinSelectorMenu::new),
        CRAFTING(WorkbenchCraftingMenu::new);

        final IMenuFactory<AbstractContainerMenu> fac;

        private MenuType(IMenuFactory<AbstractContainerMenu> factory) {
            this.fac = factory;
        }
    }

    public static interface IMenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, GunWorkbenchBlockEntity var3, ContainerData var4, ContainerLevelAccess var5);
    }
}

