/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.entity;

import com.jdolphin.ricksportalgun.common.init.PGDamageTypes;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGSounds;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PortalEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Direction> DATA_DIR = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Direction> DATA_FACING = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Float> DATA_SIZE = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_OPEN = "Open";
    public static final String TAG_NEW = "isSpawned";
    public static final String TAG_COOLDOWN = "Cooldown";
    public static final String TAG_DIR = "Direction";
    public static final String TAG_FACING = "Facing";
    public static final String TAG_SIZE = "Size";
    public static final String TAG_ACIDIC = "Bootleg";
    public static final String TAG_COLOR = "Color";
    private BlockPos targetPos;
    private boolean bootleg;
    private boolean exists;
    private Vec3 pos;
    private String targetDim;
    private int delay = 0;
    public int lifetime = 200;

    public boolean exists() {
        return this.exists;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public PortalEntity(EntityType<PortalEntity> type, Level level) {
        super(type, level);
    }

    public PortalEntity(Level pLevel, Vec3 pos, Direction direction, Direction facing, float size) {
        super(PGEntities.PORTAL, pLevel);
        this.setPos(pos);
        this.setPortalDirection(direction);
        this.setPortalFacing(facing);
        this.setSize(size);
        this.pos = pos;
    }

    public void setLifetime(int lifetime) {
        this.entityData.set(LIFETIME, (Object)lifetime);
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(LIFETIME);
    }

    public void setColor(int color) {
        this.entityData.set(DATA_COLOR_ID, (Object)color);
    }

    public void setPortalDirection(Direction direction) {
        this.entityData.set(DATA_DIR, (Object)direction);
    }

    public void setPortalFacing(Direction direction) {
        this.entityData.set(DATA_FACING, (Object)direction);
    }

    public Direction getPortalFacing() {
        return (Direction)this.entityData.get(DATA_FACING);
    }

    public Direction getPortalDirection() {
        return (Direction)this.entityData.get(DATA_DIR);
    }

    public int getColor() {
        return (Integer)this.entityData.get(DATA_COLOR_ID);
    }

    public float getSize() {
        return ((Float)this.entityData.get(DATA_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.entityData.set(DATA_SIZE, (Object)Float.valueOf(size));
    }

    public boolean isBootleg() {
        return this.bootleg;
    }

    public void setBootleg(boolean bootleg) {
        this.bootleg = bootleg;
    }

    public static boolean colliding(Entity entity1, Entity entity2) {
        return entity1.getBoundingBox().intersects(entity2.getBoundingBox());
    }

    public void kill() {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean hurt(@NotNull DamageSource damageSource, float v) {
        return false;
    }

    public boolean isFlat() {
        Direction direction = (Direction)this.entityData.get(DATA_DIR);
        return direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN);
    }

    public void setHopLocation(ResourceLocation dimension, BlockPos pos) {
        this.targetDim = dimension.toString();
        this.targetPos = pos;
    }

    public BlockPos getHopLoc() {
        return this.targetPos == null ? BlockPos.ZERO : this.targetPos;
    }

    public String getHopDim() {
        return this.targetDim == null ? "minecraft:overworld" : this.targetDim;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.bootleg = tag.getBoolean(TAG_ACIDIC);
        this.targetDim = tag.getString(TAG_DIMENSION);
        this.targetPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)TAG_BPOS).orElse(BlockPos.ZERO);
        this.setColor(tag.getInt(TAG_COLOR));
        this.setLifetime(tag.getInt(TAG_OPEN));
        this.delay = tag.getInt(TAG_COOLDOWN);
        this.exists = tag.getBoolean(TAG_NEW);
        this.setPortalDirection(Direction.byName((String)tag.getString(TAG_DIR)));
        this.setPortalFacing(Direction.byName((String)tag.getString(TAG_FACING)));
        this.setSize(tag.getFloat(TAG_SIZE));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean(TAG_ACIDIC, this.bootleg);
        tag.putBoolean(TAG_NEW, this.exists);
        tag.putString(TAG_DIMENSION, this.getHopDim());
        tag.put(TAG_BPOS, NbtUtils.writeBlockPos((BlockPos)this.getHopLoc()));
        tag.putInt(TAG_COLOR, this.getColor());
        tag.putInt(TAG_OPEN, this.getLifetime());
        tag.putInt(TAG_COOLDOWN, this.delay);
        tag.putString(TAG_DIR, this.getPortalDirection().getName());
        tag.putString(TAG_FACING, this.getPortalFacing().getName());
        tag.putFloat(TAG_SIZE, this.getSize());
    }

    public void setPos(double x, double y, double z) {
        this.pos = new Vec3(x, y, z);
        this.setPosRaw(x, y, z);
        this.recalculateBoundingBox();
    }

    protected final void recalculateBoundingBox() {
        Direction direction = (Direction)this.entityData.get(DATA_DIR);
        Direction facing = (Direction)this.entityData.get(DATA_FACING);
        AABB aabb = this.calculateBoundingBox(this.pos, direction, facing);
        Vec3 vec3 = aabb.getCenter();
        this.setPosRaw(vec3.x, vec3.y, vec3.z);
        this.setBoundingBox(aabb);
    }

    protected AABB calculateBoundingBox(Vec3 vec3, Direction dir, Direction facing) {
        double d2;
        Direction.Axis axis = dir.getAxis();
        boolean flat = axis.equals((Object)Direction.Axis.Y);
        double height = this.getSize() > 2.0f ? (double)this.getSize() : 2.0;
        double d0 = axis.equals((Object)Direction.Axis.X) ? 0.1 : (double)this.getSize();
        double d1 = flat ? 0.1 : height;
        double d = d2 = axis.equals((Object)Direction.Axis.Z) ? 0.1 : (double)this.getSize();
        if (flat) {
            Direction.Axis axis2d = facing.getAxis();
            d0 = axis2d.equals((Object)Direction.Axis.X) ? height : (double)this.getSize();
            d2 = axis2d.equals((Object)Direction.Axis.Z) ? height : (double)this.getSize();
        }
        return AABB.ofSize((Vec3)vec3, (double)d0, (double)d1, (double)d2);
    }

    public static List<Entity> getEntitiesNearby(Entity entity, double range) {
        if (!entity.level().isClientSide()) {
            AABB boundingBox = entity.getBoundingBox().inflate(range);
            List entities = entity.level().getEntitiesOfClass(Entity.class, boundingBox);
            entities.remove(entity);
            entities.removeIf(e -> {
                String entityAsString = PGHelper.getEntityAsString(e.getType());
                return PGConfigHelper.getDisabledEntities().contains(entityAsString);
            });
            entities.removeIf(e -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    return player.isOnPortalCooldown() || player.isChangingDimension() || !player.canUsePortal(false);
                }
                return false;
            });
            return entities;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_COLOR_ID, (Object)Color.GREEN.getRGB());
        builder.define(DATA_DIR, (Object)Direction.SOUTH);
        builder.define(DATA_FACING, (Object)Direction.SOUTH);
        builder.define(DATA_SIZE, (Object)Float.valueOf(1.0f));
        builder.define(LIFETIME, (Object)PGHelper.seconds(10));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            if (!this.exists) {
                LevelHelper.playSound(this.level(), this.blockPosition(), PGSounds.PORTAL_SHOOT, SoundSource.PLAYERS);
                this.exists = true;
            }
            if (this.getLifetime() > 0) {
                int l = this.getLifetime();
                this.setLifetime(l - 1);
            }
            if (this.delay > 0) {
                --this.delay;
            }
            if (!this.firstTick && this.getLifetime() == 0) {
                this.kill();
                return;
            }
            List<Entity> entityList = PortalEntity.getEntitiesNearby(this, 0.3);
            if (entityList != null) {
                for (Entity nearby : entityList) {
                    BlockPos destinationPos;
                    ServerLevel destinationDim;
                    if (!this.bootleg && !LevelHelper.isBlenderDestination(this.getHopDim())) {
                        ResourceKey<Level> key = LevelHelper.getWorldKey(ResourceLocation.parse((String)this.getHopDim()));
                        destinationDim = LevelHelper.getServerWorld(this.level(), key);
                        destinationPos = this.getHopLoc();
                    } else {
                        destinationDim = LevelHelper.getRandomServerLevel(serverLevel.getServer());
                        destinationPos = LevelHelper.getSafePos(LevelHelper.getRandomCoord(serverLevel, 5000), serverLevel);
                    }
                    if (!PortalEntity.colliding(this, nearby) || nearby.is((Entity)this) || nearby.isOnPortalCooldown() || nearby.isPassenger()) continue;
                    if (this.bootleg || LevelHelper.isBlenderDestination(this.getHopDim())) {
                        if (!(nearby instanceof LivingEntity)) continue;
                        LivingEntity living = (LivingEntity)nearby;
                        living.hurt(PGDamageTypes.of((Level)serverLevel, LevelHelper.isBlenderDestination(this.getHopDim()) ? PGDamageTypes.BLENDER : PGDamageTypes.BOOTLEG), living.getMaxHealth() * 10.0f);
                        continue;
                    }
                    if (destinationDim == null || destinationDim.isClientSide() || !nearby.canUsePortal(false) || this.delay != 0) continue;
                    Vec3 look = Vec3.directionFromRotation((Vec2)new Vec2(45.0f, this.getYRot() + 180.0f));
                    double dx = (double)destinationPos.getX() + look.x * 2.0;
                    double dz = (double)destinationPos.getZ() + look.z * 2.0;
                    HashSet<RelativeMovement> relativeSet = new HashSet<RelativeMovement>();
                    relativeSet.add(RelativeMovement.Y_ROT);
                    nearby.teleportTo(destinationDim, dx, (double)destinationPos.getY(), dz, relativeSet, nearby.getYRot(), nearby.getXRot());
                    nearby.resetFallDistance();
                    nearby.setPortalCooldown();
                }
            }
        }
    }
}

