/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;

public class PGDataComponents {
    private static final Map<ResourceLocation, DataComponentType<?>> ALL = new HashMap();
    public static final DataComponentType<BlockPos> PORTAL_POS = PGDataComponents.registerComponent("portal_pos", typeBuilder -> typeBuilder.persistent(BlockPos.CODEC));
    public static final DataComponentType<ResourceLocation> PORTAL_DIM = PGDataComponents.registerComponent("portal_dim", typeBuilder -> typeBuilder.persistent(ResourceLocation.CODEC));
    public static final DataComponentType<Integer> DEFAULT_PORTAL_COLOUR = PGDataComponents.registerInteger("default_color");
    public static final DataComponentType<Boolean> BOOTLEG = PGDataComponents.registerBoolean("bootleg");
    public static final DataComponentType<Integer> PORTAL_COLOUR = PGDataComponents.registerInteger("portal_color");
    public static final DataComponentType<Integer> FUEL = PGDataComponents.registerInteger("fuel");
    public static final DataComponentType<Integer> MAX_FUEL = PGDataComponents.registerInteger("max_fuel");
    public static final DataComponentType<Boolean> LOCK = PGDataComponents.registerBoolean("lock");
    public static final DataComponentType<String> OWNER = PGDataComponents.registerComponent("owner", typeBuilder -> typeBuilder.persistent((Codec)Codec.STRING));
    public static final DataComponentType<Integer> PORTAL_LIFETIME = PGDataComponents.registerInteger("size");
    public static final DataComponentType<List<Waypoint>> WAYPOINTS = PGDataComponents.registerComponent("waypoints", typeBuilder -> typeBuilder.persistent(Waypoint.CODEC.listOf()).networkSynchronized(Waypoint.PACKET_CODEC.apply(ByteBufCodecs.list())).cacheEncoding());
    public static DataComponentType<PortalGunStyle> PORTAL_GUN_STYLE = PGDataComponents.registerComponent("portal_gun_style", typeBuilder -> typeBuilder.persistent(PortalGunStyle.CODEC).networkSynchronized(PortalGunStyle.PACKET_CODEC).cacheEncoding());
    public static final DataComponentType<Integer> PRIMARY_DYE = PGDataComponents.registerInteger("primary_dye");
    public static final DataComponentType<Integer> SECONDARY_DYE = PGDataComponents.registerInteger("secondary_dye");
    public static final DataComponentType<Float> PORTAL_SIZE = PGDataComponents.registerComponent("portal_size", typeBuilder -> typeBuilder.persistent((Codec)Codec.FLOAT));
    public static final DataComponentType<String> CODE = PGDataComponents.registerComponent("code", typeBuilder -> typeBuilder.persistent((Codec)Codec.STRING));
    public static final DataComponentType<Boolean> SELF_DESTRUCT = PGDataComponents.registerBoolean("self_destruct");
    public static final DataComponentType<Boolean> HAS_WAYPOINTS = PGDataComponents.registerBoolean("has_waypoints");
    public static final DataComponentType<Boolean> EXTRA_DIMENSIONS = PGDataComponents.registerBoolean("more_dimensions");
    public static final DataComponentType<Boolean> EXTRA_DIMENSIONS_2 = PGDataComponents.registerBoolean("extra_dimensions");
    public static final DataComponentType<Boolean> SETTINGS = PGDataComponents.registerBoolean("settings");
    public static final DataComponentType<Boolean> BIOME_LOC = PGDataComponents.registerBoolean("biome_locating");
    public static final DataComponentType<Boolean> PLAYER_LOC = PGDataComponents.registerBoolean("player_locating");
    public static final DataComponentType<Boolean> STRUCTURE_LOC = PGDataComponents.registerBoolean("structure_locating");

    private static DataComponentType<Boolean> registerBoolean(String name) {
        return PGDataComponents.registerComponent(name, tBuilder -> tBuilder.persistent((Codec)Codec.BOOL));
    }

    private static DataComponentType<Integer> registerInteger(String name) {
        return PGDataComponents.registerComponent(name, tBuilder -> tBuilder.persistent((Codec)Codec.INT).cacheEncoding());
    }

    private static <T> DataComponentType<T> registerComponent(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        DataComponentType type = ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build();
        ALL.put(PGHelper.id(name), type);
        return type;
    }

    public static void init(BiConsumer<DataComponentType<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, DataComponentType<?>> e : ALL.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }
}

