/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBLocatePacket(String name, int value) implements PGPayload
{
    public static final StreamCodec<FriendlyByteBuf, SBLocatePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SBLocatePacket::name, (StreamCodec)ByteBufCodecs.INT, SBLocatePacket::value, SBLocatePacket::new);
    public static final CustomPacketPayload.Type<SBLocatePacket> ID = new CustomPacketPayload.Type(PGHelper.id("locate"));

    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.server;
        ServerLevel level = player.serverLevel();
        ItemStack stack = player.getItemInHand(PGHelper.getPortalGunHand((Player)player));
        if (this.value == 0) {
            if (!PGConfigHelper.disableBiomeLocating()) {
                Optional optionalRegistry = server.registryAccess().lookup(Registries.BIOME);
                if (optionalRegistry.isPresent()) {
                    ResourceLocation location = ResourceLocation.parse((String)this.name);
                    Pair pair = level.findClosestBiome3d(biomeHolder -> biomeHolder.is(location), player.blockPosition(), 6400, 32, 64);
                    if (pair != null) {
                        BlockPos pos = (BlockPos)pair.getFirst();
                        BlockPos safePos = LevelHelper.safeY(level, pos.getX(), player.getY(), pos.getZ());
                        PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)player), safePos);
                        PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                    } else {
                        PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.biome.not_in_area", (Object[])new Object[]{this.name}));
                    }
                    return;
                }
            } else {
                PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.biome.disabled"));
                return;
            }
        }
        if (this.value == 1) {
            if (!PGConfigHelper.disablePlayerLocating()) {
                ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(this.name);
                if (targetPlayer != null) {
                    PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)targetPlayer), targetPlayer.blockPosition().above());
                    PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                } else {
                    PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.player.not_found", (Object[])new Object[]{this.name}));
                }
                return;
            }
            PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.player.disabled"));
            return;
        }
        if (this.value == 2) {
            if (!PGConfigHelper.disableStructureLocating()) {
                ResourceLocation rl = ResourceLocation.parse((String)this.name);
                ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)rl);
                Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
                HolderSet holderset = (HolderSet)registry.getHolder(resourceKey).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).orElseThrow();
                Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
                Pair pair = level.getChunkSource().getGenerator().findNearestMapStructure(level, holderset, player.blockPosition(), 100, false);
                stopwatch.stop();
                if (pair == null) {
                    PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.structure.not_in_area", (Object[])new Object[]{this.name}));
                } else {
                    BlockPos pos = (BlockPos)pair.getFirst();
                    BlockPos safePos = LevelHelper.safeY(level, pos.getX(), player.getY(), pos.getZ());
                    System.out.println(String.valueOf(pos) + " compared to " + String.valueOf(safePos));
                    PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((Player)player), safePos);
                    PGHelper.sendSuccessMsg((Player)player, PGHelper.COORDS_SET);
                }
            } else {
                PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.structure.disabled"));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

