/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBOpenCoordGuiPacket() implements PGPayload
{
    public static final StreamCodec<FriendlyByteBuf, SBOpenCoordGuiPacket> CODEC = StreamCodec.unit((Object)new SBOpenCoordGuiPacket());
    public static final CustomPacketPayload.Type<SBOpenCoordGuiPacket> ID = new CustomPacketPayload.Type(PGHelper.id("open_coord_menu"));

    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.server;
        ItemStack stack = player.getItemInHand(PGHelper.getPortalGunHand((Player)player));
        if (PGHelper.canPlayerAccessGun((Player)player, stack)) {
            List<String> dims = LevelHelper.getDimensionsAsString(server.getAllLevels());
            if (!dims.contains(PGHelper.id("blender").toString())) {
                dims.add(PGHelper.id("blender").toString());
            }
            PGHelper.sendPacketToClient((ServerPlayer)player, (CustomPacketPayload[])new CBOpenCoordGuiPacket[]{new CBOpenCoordGuiPacket(dims)});
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

