/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.PGPayload;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SBSecuritySettingsPacket(boolean lock, String name, String code, boolean selfDestruct) implements PGPayload
{
    public static final StreamCodec<FriendlyByteBuf, SBSecuritySettingsPacket> CODEC;
    public static final CustomPacketPayload.Type<SBSecuritySettingsPacket> ID;

    @Override
    public void handle(ServerPlayer player) {
        MinecraftServer server = player.server;
        ItemStack stack = player.getItemInHand(PGHelper.getPortalGunHand((Player)player));
        stack.set(PGDataComponents.LOCK, (Object)this.lock);
        stack.set(PGDataComponents.SELF_DESTRUCT, (Object)this.selfDestruct);
        if (!this.code.isEmpty()) {
            PortalGunItem.setCode(stack, this.code);
        }
        if (!this.name.isEmpty()) {
            ServerPlayer newOwner = server.getPlayerList().getPlayerByName(this.name);
            if (newOwner != null) {
                stack.set(PGDataComponents.OWNER, (Object)newOwner.getStringUUID());
            } else {
                PGHelper.sendFailMsg((Player)player, Component.translatable((String)"error.ricksportalgun.locating.player.not_found", (Object[])new Object[]{this.name}));
            }
        }
        PGHelper.sendSuccessMsg((Player)player, "notice.ricksportalgun.settings.applied");
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    static {
        ID = new CustomPacketPayload.Type(PGHelper.id("settings"));
        CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SBSecuritySettingsPacket::lock, (StreamCodec)ByteBufCodecs.STRING_UTF8, SBSecuritySettingsPacket::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, SBSecuritySettingsPacket::code, (StreamCodec)ByteBufCodecs.BOOL, SBSecuritySettingsPacket::selfDestruct, SBSecuritySettingsPacket::new);
    }
}

