/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.recipe;

import java.util.List;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.NotNull;

public class WorkbenchRecipeInput
implements RecipeInput {
    private final int ingredientCount;
    private final List<ItemStack> items;
    private final StackedContents stackedContents = new StackedContents();

    public WorkbenchRecipeInput(List<ItemStack> stacks) {
        this.items = stacks;
        int i = 0;
        for (ItemStack itemstack : stacks) {
            if (itemstack.isEmpty()) continue;
            ++i;
            this.stackedContents.accountStack(itemstack);
        }
        this.ingredientCount = i;
    }

    public StackedContents stackedContents() {
        return this.stackedContents;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return this.items.get(i);
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public int size() {
        return this.items.size();
    }
}

