/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class GuiHelper {
    public static void renderWidgets(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick, AbstractWidget ... widgets) {
        for (AbstractWidget widget : widgets) {
            if (widget == null) continue;
            widget.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    public static void drawWordWrap(GuiGraphics graphics, Font font, FormattedText text, int x, int y, int lineWidth, int color) {
        for (FormattedCharSequence formattedcharsequence : font.split(text, lineWidth)) {
            graphics.drawCenteredString(font, formattedcharsequence, x, y, color);
            y += 9;
        }
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Component text, int minX, int minY, int maxX, int maxY, int color) {
        GuiHelper.renderScrollingString(guiGraphics, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        Font font = Minecraft.getInstance().font;
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, text, minX - (int)d3, j, color);
            guiGraphics.disableScissor();
        } else {
            int i1 = Mth.clamp((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            guiGraphics.drawCenteredString(font, text, i1, j, color);
        }
    }

    public static void drawWhiteString(GuiGraphics graphics, String text, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)text), x, y, Color.WHITE.getRGB());
    }

    public static void drawWhiteString(GuiGraphics graphics, Component text, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, Color.WHITE.getRGB());
    }

    public static void drawWhiteCenteredString(GuiGraphics graphics, Component text, int x, int y) {
        GuiHelper.drawWhiteCenteredString(graphics, text.getString(), x, y);
    }

    public static void drawWhiteCenteredString(GuiGraphics graphics, String text, int x, int y) {
        graphics.drawCenteredString(Minecraft.getInstance().font, text, x, y, Color.WHITE.getRGB());
    }

    public static void renderOutline(GuiGraphics graphics, AbstractWidget widget, int color) {
        if (widget != null) {
            graphics.renderOutline(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), color);
        }
    }

    public static void setTooltip(AbstractWidget widget, Component component) {
        if (widget != null && component != null) {
            Tooltip tooltip = Tooltip.create((Component)component);
            widget.setTooltip(tooltip);
        }
    }

    public static void renderTooltip(GuiGraphics graphics, Component component, AbstractWidget widget) {
        if (widget.isHovered()) {
            graphics.renderTooltip(Minecraft.getInstance().font, component, widget.getX(), widget.getY());
        }
    }

    public static Style getStyle(int x, int y) {
        return Minecraft.getInstance().gui.getChat().getClickedComponentStyleAt((double)x, (double)y);
    }
}

