/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import com.google.common.collect.Lists;
import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.util.platform.PGServices;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PGHelper {
    public static MutableComponent COORDS_SET = Component.translatable((String)"notice.ricksportalgun.destination.set");

    public static ResourceLocation id(String string) {
        return ResourceLocation.fromNamespaceAndPath((String)"ricksportalgun", (String)string);
    }

    public static int seconds(int amount) {
        return 20 * amount;
    }

    public static int minutes(int amount) {
        return 60 * PGHelper.seconds(amount);
    }

    public static boolean canPlayerAccessGun(Player player, ItemStack stack) {
        boolean locked = (Boolean)stack.getOrDefault(PGDataComponents.LOCK, (Object)false);
        String uuid = (String)stack.getOrDefault(PGDataComponents.OWNER, (Object)"");
        if (locked) {
            return player.getStringUUID().equals(uuid);
        }
        return true;
    }

    public static String getEntityAsString(EntityType<?> type) {
        ResourceLocation rl = BuiltInRegistries.ENTITY_TYPE.getKey(type);
        return rl.toString();
    }

    public static InteractionHand getPortalGunHand(Player player) {
        InteractionHand hand = !player.getMainHandItem().is(PGTags.Items.PORTAL_GUNS) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        return hand;
    }

    public static InteractionHand getOppositeHand(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static List<String> defaultDisabledEntities() {
        return Lists.newArrayList((Object[])new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:warden", "ricksportalgun:portal"});
    }

    public static void sendSuccessMsg(Player player, String msg) {
        PGHelper.sendSuccessMsg(player, Component.translatable((String)msg));
    }

    public static void sendSuccessMsg(Player player, MutableComponent msg) {
        player.displayClientMessage((Component)msg.withStyle(ChatFormatting.GREEN), false);
    }

    public static void sendFailMsg(Player player, MutableComponent msg) {
        player.displayClientMessage((Component)msg.withStyle(ChatFormatting.RED), false);
    }

    public static void sendFailMsg(Player player, String msg) {
        PGHelper.sendFailMsg(player, Component.translatable((String)msg));
    }

    public static <P extends CustomPacketPayload> void sendPacketToServer(P packet) {
        PGServices.PLATFORM.sendPacketToServer(packet);
    }

    public static <P extends CustomPacketPayload> void sendPacketToClient(ServerPlayer player, P ... packet) {
        PGServices.PLATFORM.sendPacketToClient(player, (CustomPacketPayload[])packet);
    }

    public static <T> T getRandomFromList(List<T> list) {
        int i = list.size();
        int index = PGConstants.RANDOM.nextInt(i);
        return list.get(index);
    }
}

