/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item.upgrade;

import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.item.upgrade.SimpleUpgradeItem;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SimpleConditionalUpgradeItem
extends SimpleUpgradeItem {
    protected BiFunction<ItemStack, PortalGunItem, Boolean> condition;
    protected Component errorMsg = null;

    public SimpleConditionalUpgradeItem(Item.Properties properties, BiConsumer<ItemStack, PortalGunItem> onApply, BiFunction<ItemStack, PortalGunItem, Boolean> condition) {
        super(properties, onApply);
        this.condition = condition;
    }

    public SimpleConditionalUpgradeItem(Item.Properties properties, BiConsumer<ItemStack, PortalGunItem> onApply, BiFunction<ItemStack, PortalGunItem, Boolean> condition, Component errorMsg) {
        this(properties, onApply, condition);
        this.errorMsg = errorMsg;
    }

    @Override
    public InteractionResult applyUpgrade(Player player, ItemStack stack, PortalGunItem item) {
        if (this.condition.apply(stack, item).booleanValue()) {
            super.applyUpgrade(player, stack, item);
            return InteractionResult.SUCCESS;
        }
        if (this.errorMsg != null) {
            PGHelper.sendFailMsg(player, this.errorMsg.m_6881_());
        }
        return InteractionResult.FAIL;
    }
}

