/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.util.helper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.alminoris.aestheticedges.util.helper.ModJsonTemplates;

public class ModJsonHelper {
    public static void createBlockModel(String jsonContent, String name, String textureName) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticedges/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = name + ".json";
        File modelFile = new File(directory, fileName);
        jsonContent = jsonContent.replace("NAME", textureName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createCurtainRodBlockModel(String jsonContent, String name, String textureName, String color, String variant, boolean isDressed, boolean isOpened) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticedges/models/block/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = name + (String)(variant.equals("normal") ? "" : "_" + variant) + (isDressed ? "_dressed" : "") + (String)(isDressed ? "_" + color : "") + (isOpened ? "_opened" : "") + ".json";
        File modelFile = new File(directory, fileName);
        jsonContent = jsonContent.replace("NAME", textureName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createStonecuttingRecipe(String ingredientName, String outputName, String count) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/data/aestheticedges/recipe/";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = outputName + "_from_" + ingredientName.split(":")[1] + "_stonecutting.json";
        File modelFile = new File(directory, fileName);
        String jsonContent = ModJsonTemplates.STONECUTTING_RECIPE.replace("COUNT", count).replace("INGREDIENT_NAME", ingredientName).replace("OUTPUT_NAME", outputName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createBlockstate(String name, String accurateName, String jsonTemplate) {
        String projectPath = System.getProperty("user.dir");
        String filePath = projectPath.replace("build\\datagen", "src\\main\\resources") + "/assets/aestheticedges/blockstates";
        File directory = new File(filePath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = name + ".json";
        File modelFile = new File(directory, fileName);
        String jsonContent = jsonTemplate.replace("NAME", accurateName);
        try (FileWriter writer = new FileWriter(modelFile);){
            writer.write(jsonContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createCurtainRodBlockModel(String name, String materialName, String colorName, String variantName, boolean isDressed, boolean isOpened) {
        switch (variantName) {
            case "normal": {
                if (isDressed) {
                    if (isOpened) {
                        ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_DRESSED_OPENED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, true);
                        break;
                    }
                    ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_DRESSED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, false);
                    break;
                }
                ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD, name, materialName, colorName, variantName, false, false);
                break;
            }
            case "left": {
                if (isDressed) {
                    if (isOpened) {
                        ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_LEFT_DRESSED_OPENED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, true);
                        break;
                    }
                    ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_LEFT_DRESSED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, false);
                    break;
                }
                ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_LEFT, name, materialName, colorName, variantName, false, false);
                break;
            }
            case "right": {
                if (isDressed) {
                    if (isOpened) {
                        ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_RIGHT_DRESSED_OPENED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, true);
                        break;
                    }
                    ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_RIGHT_DRESSED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, false);
                    break;
                }
                ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_RIGHT, name, materialName, colorName, variantName, false, false);
                break;
            }
            case "center": {
                if (isDressed) {
                    if (isOpened) {
                        ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_CENTER_DRESSED_OPENED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, true);
                        break;
                    }
                    ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_CENTER_DRESSED.replace("COLOR_NAME", colorName), name, materialName, colorName, variantName, true, false);
                    break;
                }
                ModJsonHelper.createCurtainRodBlockModel(ModJsonTemplates.CURTAIN_ROD_CENTER, name, materialName, colorName, variantName, false, false);
            }
        }
    }
}

