/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.block.custom;

import net.alminoris.aestheticedges.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticedges.item.ModItems;
import net.alminoris.aestheticedges.util.ModTags;
import net.alminoris.aestheticedges.util.helper.BlockShape;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class CurtainRodBlock
extends YAxisRotatedBlock {
    public static final class_2754<Color> COLOR = class_2754.method_11850((String)"color", Color.class);
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);
    public static final class_2746 DRESSED = class_2746.method_11825((String)"dressed");
    public static final class_2746 OPENED = class_2746.method_11825((String)"opened");

    public CurtainRodBlock(class_4970.class_2251 settings, BlockShape ... shapes) {
        super(settings, shapes);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL))).method_11657((class_2769)DRESSED, (Comparable)Boolean.valueOf(false))).method_11657(COLOR, (Comparable)((Object)Color.BLACK))).method_11657((class_2769)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{VARIANT, DRESSED, COLOR, OPENED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        boolean currentDressed = (Boolean)state.method_11654((class_2769)DRESSED);
        boolean currentOpened = (Boolean)state.method_11654((class_2769)OPENED);
        Variant currentVariant = (Variant)((Object)state.method_11654(VARIANT));
        if (stack.method_31573(ModTags.Items.CURTAINS) && !currentDressed) {
            if (!world.field_9236) {
                class_2350 currentFacing = (class_2350)state.method_11654((class_2769)FACING);
                String colorName = class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12832().replace("curtain_", "");
                world.method_8501(pos, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)currentFacing)).method_11657(VARIANT, (Comparable)((Object)currentVariant))).method_11657((class_2769)DRESSED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)OPENED, (Comparable)Boolean.valueOf(currentOpened))).method_11657(COLOR, (Comparable)((Object)Color.fromString(colorName))));
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (stack.method_7960() && currentDressed) {
            if (!world.field_9236) {
                class_2350 currentFacing = (class_2350)state.method_11654((class_2769)FACING);
                Color currentColor = (Color)((Object)state.method_11654(COLOR));
                world.method_8501(pos, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)currentFacing)).method_11657(VARIANT, (Comparable)((Object)currentVariant))).method_11657((class_2769)DRESSED, (Comparable)Boolean.valueOf(currentDressed))).method_11657((class_2769)OPENED, (Comparable)Boolean.valueOf(!currentOpened))).method_11657(COLOR, (Comparable)((Object)currentColor)));
                if (stack.method_7919() < stack.method_7936() - 1) {
                    stack.method_7974(stack.method_7919() + 1);
                } else {
                    stack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        if (stack.method_31574(ModItems.CURTAIN_REMOVER)) {
            if (!world.field_9236) {
                class_2350 currentFacing = (class_2350)state.method_11654((class_2769)FACING);
                Color currentColor = (Color)((Object)state.method_11654(COLOR));
                String colorName = currentColor.method_15434();
                world.method_8501(pos, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)currentFacing)).method_11657(VARIANT, (Comparable)((Object)currentVariant))).method_11657((class_2769)DRESSED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)OPENED, (Comparable)Boolean.valueOf(currentOpened))).method_11657(COLOR, (Comparable)((Object)currentColor)));
                if (stack.method_7919() < stack.method_7936() - 1) {
                    stack.method_7974(stack.method_7919() + 1);
                } else {
                    stack.method_7934(1);
                }
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(class_2960.method_43902((String)"aestheticedges", (String)("curtain_" + colorName)));
                class_1799 carpetStack = new class_1799((class_1935)item);
                if (!player.method_31548().method_7394(carpetStack)) {
                    player.method_7328(carpetStack, false);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.updateCurtainRodVariant(state, world, pos);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateSurroundingCurtainRodes(world, pos);
    }

    private void updateSurroundingCurtainRodes(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_26204() != this) continue;
            world.method_8501(neighborPos, this.updateCurtainRodVariant(neighborState, (class_1936)world, neighborPos));
        }
    }

    private class_2680 updateCurtainRodVariant(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        boolean leftConnected = this.isCurtainRod(world, leftPos, facing);
        boolean rightConnected = this.isCurtainRod(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isCurtainRod(class_1936 world, class_2338 pos, class_2350 facing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() == this && state.method_11654((class_2769)FACING) == facing;
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right"),
        CENTER("center");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public static Variant fromString(String name) {
            for (Variant inside : Variant.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static enum Color implements class_3542
    {
        BLACK("black"),
        BROWN("brown"),
        GRAY("gray"),
        LIGHT_GRAY("light_gray"),
        WHITE("white"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink"),
        BLUE("blue"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        GREEN("green"),
        LIME("lime");

        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public static Color fromString(String name) {
            for (Color inside : Color.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String method_15434() {
            return this.name;
        }
    }
}

