/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.block.custom;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.decor.DecorationType;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.FishTankBlockEntity;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.ModBlockEntities;
import net.mint_gaming_studios.betterfishtanksmod.item.custom.FishBagItem;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FishTankBlock
extends BaseEntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final EnumProperty<FloorType> FLOOR = EnumProperty.m_61587_((String)"floor", FloorType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape EAST_WALL = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_WALL = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape DOWN_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape DRIPSTONE_COLLISION_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape CAVE_PART_COLLISION_SHAPE = Shapes.m_83144_();
    protected static final VoxelShape BRANCH_PART_COLLISION_SHAPE = Shapes.m_83144_();
    protected static final VoxelShape CAVE_NORTH_OPENING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0), Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)1.0), Block.m_49796_((double)5.0, (double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)1.0)});
    protected static final VoxelShape CAVE_EAST_OPENING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0), Block.m_49796_((double)15.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0, (double)11.0), Block.m_49796_((double)15.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0)});
    protected static final VoxelShape CAVE_SOUTH_OPENING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)5.0, (double)16.0, (double)16.0), Block.m_49796_((double)11.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)5.0, (double)0.0, (double)15.0, (double)11.0, (double)5.0, (double)16.0), Block.m_49796_((double)5.0, (double)11.0, (double)15.0, (double)11.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape CAVE_WEST_OPENING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)5.0), Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)5.0, (double)11.0), Block.m_49796_((double)0.0, (double)11.0, (double)5.0, (double)1.0, (double)16.0, (double)11.0)});
    private final Map<BlockState, VoxelShape> shapeCache;

    public FishTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_(FLOOR, (Comparable)((Object)FloorType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeCache = this.makeShapes();
    }

    private Map<BlockState, VoxelShape> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean north : NORTH.m_6908_()) {
            for (Boolean east : EAST.m_6908_()) {
                for (Boolean south : SOUTH.m_6908_()) {
                    for (Boolean west : WEST.m_6908_()) {
                        for (Boolean up : UP.m_6908_()) {
                            for (Boolean down : DOWN.m_6908_()) {
                                BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)north)).m_61124_((Property)EAST, (Comparable)east)).m_61124_((Property)SOUTH, (Comparable)south)).m_61124_((Property)WEST, (Comparable)west)).m_61124_((Property)UP, (Comparable)up)).m_61124_((Property)DOWN, (Comparable)down);
                                Stream.Builder<VoxelShape> streamBuilder = Stream.builder();
                                if (!down.booleanValue()) {
                                    streamBuilder.add(DOWN_WALL);
                                }
                                if (!up.booleanValue()) {
                                    streamBuilder.add(UP_WALL);
                                }
                                if (!north.booleanValue()) {
                                    streamBuilder.add(NORTH_WALL);
                                }
                                if (!east.booleanValue()) {
                                    streamBuilder.add(EAST_WALL);
                                }
                                if (!south.booleanValue()) {
                                    streamBuilder.add(SOUTH_WALL);
                                }
                                if (!west.booleanValue()) {
                                    streamBuilder.add(WEST_WALL);
                                }
                                builder.put((Object)state, (Object)streamBuilder.build().reduce(Shapes.m_83040_(), Shapes::m_83110_));
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockState baseShapeKey = (BlockState)((BlockState)pState.m_61124_(FLOOR, (Comparable)((Object)FloorType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        VoxelShape combinedShape = this.shapeCache.get(baseShapeKey);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity fishTankBlockEntity = (FishTankBlockEntity)blockEntity;
            DecorationType decorationType = fishTankBlockEntity.getDecorationType();
            if (decorationType == DecorationType.DRIPSTONE || decorationType == DecorationType.DRIPSTONE_TOP || decorationType == DecorationType.DRIPSTONE_MIDDLE || decorationType == DecorationType.DRIPSTONE_BOTTOM) {
                combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)DRIPSTONE_COLLISION_SHAPE);
            } else if (decorationType == DecorationType.STRUCTURE_CAVE_PART) {
                combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)CAVE_PART_COLLISION_SHAPE);
            } else if (decorationType == DecorationType.STRUCTURE_BRANCH_PART) {
                combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)BRANCH_PART_COLLISION_SHAPE);
            } else if (decorationType.m_7912_().startsWith("structure_cave")) {
                Direction caveFacing = fishTankBlockEntity.getCaveFacing();
                switch (caveFacing) {
                    case NORTH: {
                        combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)CAVE_NORTH_OPENING_SHAPE);
                        break;
                    }
                    case EAST: {
                        combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)CAVE_EAST_OPENING_SHAPE);
                        break;
                    }
                    case SOUTH: {
                        combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)CAVE_SOUTH_OPENING_SHAPE);
                        break;
                    }
                    case WEST: {
                        combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)CAVE_WEST_OPENING_SHAPE);
                        break;
                    }
                }
            } else if (decorationType.m_7912_().startsWith("medium_branch")) {
                Direction branchFacing = fishTankBlockEntity.getBranchFacing();
                combinedShape = Shapes.m_83110_((VoxelShape)combinedShape, (VoxelShape)Shapes.m_83144_());
            }
        }
        return combinedShape;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidstate) {
        return false;
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Blocks.f_50058_.m_49966_();
        }
        return state;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (pLevel.f_46443_) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity newBe = (FishTankBlockEntity)blockEntity;
            BlockPos masterToJoin = null;
            for (Direction dir : Direction.values()) {
                BlockEntity blockEntity2 = pLevel.m_7702_(pPos.m_121945_(dir));
                if (!(blockEntity2 instanceof FishTankBlockEntity)) continue;
                FishTankBlockEntity neighborBe = (FishTankBlockEntity)blockEntity2;
                masterToJoin = neighborBe.getMasterPos();
                break;
            }
            if (masterToJoin != null) {
                newBe.setMasterPos(masterToJoin);
                BlockEntity blockEntity3 = pLevel.m_7702_(masterToJoin);
                if (blockEntity3 instanceof FishTankBlockEntity) {
                    FishTankBlockEntity masterBe = (FishTankBlockEntity)blockEntity3;
                    masterBe.requestScan();
                }
            } else {
                newBe.requestScan();
            }
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_155947_() && !pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof FishTankBlockEntity) {
                FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
                if (be.isMaster()) {
                    BlockEntity blockEntity2;
                    BlockPos newMasterPos = null;
                    for (Direction dir : Direction.values()) {
                        BlockPos neighborPos = pPos.m_121945_(dir);
                        if (!(pLevel.m_7702_(neighborPos) instanceof FishTankBlockEntity)) continue;
                        newMasterPos = neighborPos;
                        break;
                    }
                    if (newMasterPos != null && (blockEntity2 = pLevel.m_7702_(newMasterPos)) instanceof FishTankBlockEntity) {
                        FishTankBlockEntity newMaster = (FishTankBlockEntity)blockEntity2;
                        newMaster.copyMasterDataFrom(be);
                        newMaster.requestScan();
                    }
                } else {
                    BlockEntity blockEntity3 = pLevel.m_7702_(be.getMasterPos());
                    if (blockEntity3 instanceof FishTankBlockEntity) {
                        FishTankBlockEntity masterBe = (FishTankBlockEntity)blockEntity3;
                        masterBe.requestScan();
                    }
                }
            }
            pLevel.m_46747_(pPos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean connectsNorth = this.canConnectTo(level.m_8055_(pos.m_122012_()));
        boolean connectsEast = this.canConnectTo(level.m_8055_(pos.m_122029_()));
        boolean connectsSouth = this.canConnectTo(level.m_8055_(pos.m_122019_()));
        boolean connectsWest = this.canConnectTo(level.m_8055_(pos.m_122024_()));
        boolean connectsUp = this.canConnectTo(level.m_8055_(pos.m_7494_()));
        boolean connectsDown = this.canConnectTo(level.m_8055_(pos.m_7495_()));
        if (!level.m_5776_()) {
            LOGGER.info("Placing FishTankBlock at {}. Connections: N={}, E={}, S={}, W={}, U={}, D={}", new Object[]{pos, connectsNorth, connectsEast, connectsSouth, connectsWest, connectsUp, connectsDown});
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(connectsNorth))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(connectsEast))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(connectsSouth))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(connectsWest))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(connectsUp))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(connectsDown))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        boolean connects = this.canConnectTo(facingState);
        if (!level.m_5776_()) {
            LOGGER.info("FishTankBlock at {} updating. Neighbor at {} ({}) changed. New connection state: {}", new Object[]{currentPos, facingPos, facing, connects});
        }
        return (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(connects));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private boolean canConnectTo(BlockState state) {
        return state.m_60713_((Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, FLOOR, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FishTankBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (level.f_46443_) {
            return heldItem.m_41720_() instanceof FishBagItem ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity fishTank = (FishTankBlockEntity)blockEntity;
            BlockEntity masterBe = level.m_7702_(fishTank.getMasterPos());
            if (!(masterBe instanceof FishTankBlockEntity)) {
                fishTank.requestScan();
                return InteractionResult.FAIL;
            }
            FishTankBlockEntity masterTank = (FishTankBlockEntity)masterBe;
            if (heldItem.m_41720_() instanceof FishBagItem) {
                if (player.m_6144_() && masterTank.releaseFishFromBag(player, hand)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (heldItem.m_150930_(Items.f_42447_)) {
                if (masterTank.addWater(1000) > 0) {
                    if (!player.m_150110_().f_35937_) {
                        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_150930_(Items.f_42446_)) {
                if (masterTank.removeWater(1000) > 0) {
                    if (!player.m_150110_().f_35937_) {
                        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)masterTank, buffer -> buffer.m_130064_(masterTank.m_58899_()));
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_6724_(BlockState pState) {
        return false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity;
        BlockPos abovePos;
        BlockState aboveState;
        FishTankBlockEntity fishTankBlockEntity;
        DecorationType decoration;
        BlockEntity blockEntity2;
        if (!pLevel.f_46443_ && (blockEntity2 = pLevel.m_7702_(pPos)) instanceof FishTankBlockEntity && ((decoration = (fishTankBlockEntity = (FishTankBlockEntity)blockEntity2).getDecorationType()) == DecorationType.DRIPSTONE || decoration == DecorationType.DRIPSTONE_TOP) && pRandom.m_188503_(4) == 0 && (aboveState = pLevel.m_8055_(abovePos = pPos.m_7494_())).m_60713_((Block)this) && (blockEntity = pLevel.m_7702_(abovePos)) instanceof FishTankBlockEntity) {
            FishTankBlockEntity aboveFishTankBE = (FishTankBlockEntity)blockEntity;
            DecorationType aboveDecoration = aboveFishTankBE.getDecorationType();
            int aboveWaterLevel = aboveFishTankBE.getWaterAmount();
            if (aboveDecoration == DecorationType.NONE && aboveWaterLevel > 0) {
                if (decoration == DecorationType.DRIPSTONE) {
                    fishTankBlockEntity.setDecorationType(DecorationType.DRIPSTONE_BOTTOM);
                    aboveFishTankBE.setDecorationType(DecorationType.DRIPSTONE_TOP);
                } else {
                    BlockPos belowPos = pPos.m_7495_();
                    BlockState belowState = pLevel.m_8055_(belowPos);
                    BlockEntity blockEntity3 = pLevel.m_7702_(belowPos);
                    if (blockEntity3 instanceof FishTankBlockEntity) {
                        FishTankBlockEntity belowFishTankBE = (FishTankBlockEntity)blockEntity3;
                        DecorationType belowDecoration = belowFishTankBE.getDecorationType();
                        if (belowState.m_60713_((Block)this) && belowDecoration == DecorationType.DRIPSTONE_BOTTOM) {
                            fishTankBlockEntity.setDecorationType(DecorationType.DRIPSTONE_MIDDLE);
                            aboveFishTankBE.setDecorationType(DecorationType.DRIPSTONE_TOP);
                        }
                    }
                }
                fishTankBlockEntity.m_6596_();
                aboveFishTankBE.m_6596_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && !((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            return;
        }
        super.m_214162_(state, level, pos, random);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return FishTankBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.FISH_TANK_ENTITY.get()), FishTankBlockEntity::tick);
    }

    public static enum FloorType implements StringRepresentable
    {
        NONE("none"),
        SAND("sand"),
        GRAVEL("gravel"),
        RED_SAND("red_sand");

        private final String name;

        private FloorType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

