/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.decor.DecorationType;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.FishTankBlockEntity;

public class FishTankBlockEntityRenderer
implements BlockEntityRenderer<FishTankBlockEntity> {
    private final Map<DecorationType, BakedModel> decorationModels = new EnumMap<DecorationType, BakedModel>(DecorationType.class);
    private final BlockEntityRendererProvider.Context context;

    public FishTankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.bakeModels();
    }

    private void bakeModels() {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        for (DecorationType type : DecorationType.values()) {
            ResourceLocation modelLocation;
            if (type == DecorationType.NONE || !type.rendersModel() || (modelLocation = FishTankBlockEntityRenderer.getModelLocationForDecoration(type)) == null) continue;
            this.decorationModels.put(type, modelManager.getModel(modelLocation));
        }
    }

    public void render(FishTankBlockEntity pBlockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        DecorationType decorationType = pBlockEntity.getDecorationType();
        if (decorationType == DecorationType.NONE || !decorationType.rendersModel()) {
            return;
        }
        BakedModel model = this.decorationModels.get((Object)decorationType);
        if (model != null) {
            BlockRenderDispatcher blockRenderDispatcher = this.context.m_173584_();
            poseStack.m_85836_();
            if (decorationType.m_7912_().startsWith("structure_cave")) {
                Direction facing = pBlockEntity.getCaveFacing();
                float rotation = -facing.m_122435_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                poseStack.m_85837_(-0.5, -0.5, -0.5);
            } else if (decorationType.m_7912_().startsWith("tower")) {
                Direction facing = pBlockEntity.getTowerFacing();
                float rotation = -facing.m_122435_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                poseStack.m_85837_(0.0, 0.5, 0.0);
            } else if (decorationType.m_7912_().startsWith("medium_branch")) {
                Direction facing = pBlockEntity.getBranchFacing();
                float rotation = -facing.m_122435_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                poseStack.m_85837_(-0.5, -0.5, -0.5);
            }
            blockRenderDispatcher.m_110937_().m_111067_(poseStack.m_85850_(), bufferSource.m_6299_(RenderType.m_110463_()), decorationType.getBlockState(), model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
    }

    public static ResourceLocation getModelLocationForDecoration(DecorationType type) {
        String modId = "betterfishtanks";
        String minecraftId = "minecraft";
        return switch (type) {
            case DecorationType.SEAGRASS -> new ResourceLocation(modId, "block/fishtank/deco/seagrass/fish_tank_seagrass");
            case DecorationType.SEAGRASS_BOTTOM -> new ResourceLocation(modId, "block/fishtank/deco/seagrass/fish_tank_seagrass_bottom");
            case DecorationType.SEAGRASS_TOP -> new ResourceLocation(modId, "block/fishtank/deco/seagrass/fish_tank_seagrass_top");
            case DecorationType.KELP -> new ResourceLocation(modId, "block/fishtank/deco/kelp/fish_tank_kelp");
            case DecorationType.KELP_BOTTOM -> new ResourceLocation(modId, "block/fishtank/deco/kelp/fish_tank_kelp_bottom");
            case DecorationType.KELP_MIDDLE -> new ResourceLocation(modId, "block/fishtank/deco/kelp/fish_tank_kelp_middle");
            case DecorationType.KELP_TOP -> new ResourceLocation(modId, "block/fishtank/deco/kelp/fish_tank_kelp_top");
            case DecorationType.SEA_PICKLE_1 -> new ResourceLocation(minecraftId, "block/sea_pickle");
            case DecorationType.SEA_PICKLE_2 -> new ResourceLocation(minecraftId, "block/two_sea_pickles");
            case DecorationType.SEA_PICKLE_3 -> new ResourceLocation(minecraftId, "block/three_sea_pickles");
            case DecorationType.SEA_PICKLE_4 -> new ResourceLocation(minecraftId, "block/four_sea_pickles");
            case DecorationType.AMETHYST_1 -> new ResourceLocation(modId, "block/fishtank/deco/amethyst/fish_tank_amethyst_1");
            case DecorationType.AMETHYST_2 -> new ResourceLocation(modId, "block/fishtank/deco/amethyst/fish_tank_amethyst_2");
            case DecorationType.AMETHYST_3 -> new ResourceLocation(modId, "block/fishtank/deco/amethyst/fish_tank_amethyst_3");
            case DecorationType.AMETHYST_4 -> new ResourceLocation(modId, "block/fishtank/deco/amethyst/fish_tank_amethyst_4");
            case DecorationType.DRIPSTONE -> new ResourceLocation(modId, "block/fishtank/deco/dripstone/fish_tank_dripstone");
            case DecorationType.DRIPSTONE_BOTTOM -> new ResourceLocation(modId, "block/fishtank/deco/dripstone/fish_tank_dripstone_bottom");
            case DecorationType.DRIPSTONE_MIDDLE -> new ResourceLocation(modId, "block/fishtank/deco/dripstone/fish_tank_dripstone_middle");
            case DecorationType.DRIPSTONE_TOP -> new ResourceLocation(modId, "block/fishtank/deco/dripstone/fish_tank_dripstone_top");
            case DecorationType.CORAL_BRAIN -> new ResourceLocation(modId, "block/fishtank/deco/coral/fish_tank_coral_brain");
            case DecorationType.CORAL_BUBBLE -> new ResourceLocation(modId, "block/fishtank/deco/coral/fish_tank_coral_bubble");
            case DecorationType.CORAL_FIRE -> new ResourceLocation(modId, "block/fishtank/deco/coral/fish_tank_coral_fire");
            case DecorationType.CORAL_HORN -> new ResourceLocation(modId, "block/fishtank/deco/coral/fish_tank_coral_horn");
            case DecorationType.CORAL_TUBE -> new ResourceLocation(modId, "block/fishtank/deco/coral/fish_tank_coral_tube");
            case DecorationType.STRUCTURE_CAVE_STONE_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_stone_amethyst");
            case DecorationType.STRUCTURE_CAVE_STONE_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_stone_diamond");
            case DecorationType.STRUCTURE_CAVE_STONE_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_stone_emerald");
            case DecorationType.STRUCTURE_CAVE_STONE_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_stone_lapis");
            case DecorationType.STRUCTURE_CAVE_STONE_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_stone_redstone");
            case DecorationType.STRUCTURE_CAVE_GRANITE_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_granite_amethyst");
            case DecorationType.STRUCTURE_CAVE_GRANITE_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_granite_diamond");
            case DecorationType.STRUCTURE_CAVE_GRANITE_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_granite_emerald");
            case DecorationType.STRUCTURE_CAVE_GRANITE_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_granite_lapis");
            case DecorationType.STRUCTURE_CAVE_GRANITE_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_granite_redstone");
            case DecorationType.STRUCTURE_CAVE_DIORITE_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_diorite_amethyst");
            case DecorationType.STRUCTURE_CAVE_DIORITE_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_diorite_diamond");
            case DecorationType.STRUCTURE_CAVE_DIORITE_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_diorite_emerald");
            case DecorationType.STRUCTURE_CAVE_DIORITE_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_diorite_lapis");
            case DecorationType.STRUCTURE_CAVE_DIORITE_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_diorite_redstone");
            case DecorationType.STRUCTURE_CAVE_ANDESITE_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_andesite_amethyst");
            case DecorationType.STRUCTURE_CAVE_ANDESITE_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_andesite_diamond");
            case DecorationType.STRUCTURE_CAVE_ANDESITE_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_andesite_emerald");
            case DecorationType.STRUCTURE_CAVE_ANDESITE_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_andesite_lapis");
            case DecorationType.STRUCTURE_CAVE_ANDESITE_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_andesite_redstone");
            case DecorationType.STRUCTURE_CAVE_DEEPSLATE_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_deepslate_amethyst");
            case DecorationType.STRUCTURE_CAVE_DEEPSLATE_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_deepslate_diamond");
            case DecorationType.STRUCTURE_CAVE_DEEPSLATE_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_deepslate_emerald");
            case DecorationType.STRUCTURE_CAVE_DEEPSLATE_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_deepslate_lapis");
            case DecorationType.STRUCTURE_CAVE_DEEPSLATE_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_deepslate_redstone");
            case DecorationType.STRUCTURE_CAVE_TUFF_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_tuff_amethyst");
            case DecorationType.STRUCTURE_CAVE_TUFF_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_tuff_diamond");
            case DecorationType.STRUCTURE_CAVE_TUFF_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_tuff_emerald");
            case DecorationType.STRUCTURE_CAVE_TUFF_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_tuff_lapis");
            case DecorationType.STRUCTURE_CAVE_TUFF_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_tuff_redstone");
            case DecorationType.STRUCTURE_CAVE_CALCITE_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_calcite_amethyst");
            case DecorationType.STRUCTURE_CAVE_CALCITE_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_calcite_diamond");
            case DecorationType.STRUCTURE_CAVE_CALCITE_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_calcite_emerald");
            case DecorationType.STRUCTURE_CAVE_CALCITE_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_calcite_lapis");
            case DecorationType.STRUCTURE_CAVE_CALCITE_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_calcite_redstone");
            case DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_AMETHYST -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_dripstone_block_amethyst");
            case DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_DIAMOND -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_dripstone_block_diamond");
            case DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_EMERALD -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_dripstone_block_emerald");
            case DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_LAPIS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_dripstone_block_lapis");
            case DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_REDSTONE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_deco_cave_dripstone_block_redstone");
            case DecorationType.TINY_STONE_STONE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_stone");
            case DecorationType.TINY_STONE_GRANITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_granite");
            case DecorationType.TINY_STONE_DIORITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_diorite");
            case DecorationType.TINY_STONE_ANDESITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_andesite");
            case DecorationType.TINY_STONE_DEEPSLATE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_deepslate");
            case DecorationType.TINY_STONE_TUFF -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_tuff");
            case DecorationType.TINY_STONE_CALCITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_calcite");
            case DecorationType.TINY_STONE_DRIPSTONE_BLOCK -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_tiny_dripstone_block");
            case DecorationType.SMALL_STONE_STONE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_stone");
            case DecorationType.SMALL_STONE_GRANITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_granite");
            case DecorationType.SMALL_STONE_DIORITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_diorite");
            case DecorationType.SMALL_STONE_ANDESITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_andesite");
            case DecorationType.SMALL_STONE_DEEPSLATE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_deepslate");
            case DecorationType.SMALL_STONE_TUFF -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_tuff");
            case DecorationType.SMALL_STONE_CALCITE -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_calcite");
            case DecorationType.SMALL_STONE_DRIPSTONE_BLOCK -> new ResourceLocation(modId, "block/fishtank/deco/stone/fish_tank_stone_small_dripstone_block");
            case DecorationType.TINY_BRANCH_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_oak");
            case DecorationType.TINY_BRANCH_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_spruce");
            case DecorationType.TINY_BRANCH_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_birch");
            case DecorationType.TINY_BRANCH_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_jungle");
            case DecorationType.TINY_BRANCH_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_acacia");
            case DecorationType.TINY_BRANCH_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_dark_oak");
            case DecorationType.TINY_BRANCH_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_mangrove");
            case DecorationType.TINY_BRANCH_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_cherry");
            case DecorationType.TINY_BRANCH_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_bamboo");
            case DecorationType.TINY_BRANCH_STRIPPED_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_oak");
            case DecorationType.TINY_BRANCH_STRIPPED_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_spruce");
            case DecorationType.TINY_BRANCH_STRIPPED_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_birch");
            case DecorationType.TINY_BRANCH_STRIPPED_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_jungle");
            case DecorationType.TINY_BRANCH_STRIPPED_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_acacia");
            case DecorationType.TINY_BRANCH_STRIPPED_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_dark_oak");
            case DecorationType.TINY_BRANCH_STRIPPED_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_mangrove");
            case DecorationType.TINY_BRANCH_STRIPPED_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_cherry");
            case DecorationType.TINY_BRANCH_STRIPPED_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_tiny_stripped_bamboo");
            case DecorationType.SMALL_BRANCH_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_oak");
            case DecorationType.SMALL_BRANCH_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_spruce");
            case DecorationType.SMALL_BRANCH_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_birch");
            case DecorationType.SMALL_BRANCH_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_jungle");
            case DecorationType.SMALL_BRANCH_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_acacia");
            case DecorationType.SMALL_BRANCH_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_dark_oak");
            case DecorationType.SMALL_BRANCH_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_mangrove");
            case DecorationType.SMALL_BRANCH_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_cherry");
            case DecorationType.SMALL_BRANCH_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_bamboo");
            case DecorationType.SMALL_BRANCH_STRIPPED_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_oak");
            case DecorationType.SMALL_BRANCH_STRIPPED_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_spruce");
            case DecorationType.SMALL_BRANCH_STRIPPED_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_birch");
            case DecorationType.SMALL_BRANCH_STRIPPED_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_jungle");
            case DecorationType.SMALL_BRANCH_STRIPPED_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_acacia");
            case DecorationType.SMALL_BRANCH_STRIPPED_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_dark_oak");
            case DecorationType.SMALL_BRANCH_STRIPPED_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_mangrove");
            case DecorationType.SMALL_BRANCH_STRIPPED_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_cherry");
            case DecorationType.SMALL_BRANCH_STRIPPED_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_small_stripped_bamboo");
            case DecorationType.MEDIUM_BRANCH_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_oak");
            case DecorationType.MEDIUM_BRANCH_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_spruce");
            case DecorationType.MEDIUM_BRANCH_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_birch");
            case DecorationType.MEDIUM_BRANCH_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_jungle");
            case DecorationType.MEDIUM_BRANCH_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_acacia");
            case DecorationType.MEDIUM_BRANCH_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_dark_oak");
            case DecorationType.MEDIUM_BRANCH_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_mangrove");
            case DecorationType.MEDIUM_BRANCH_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_cherry");
            case DecorationType.MEDIUM_BRANCH_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_bamboo");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_oak");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_spruce");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_birch");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_jungle");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_acacia");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_dark_oak");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_mangrove");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_cherry");
            case DecorationType.MEDIUM_BRANCH_STRIPPED_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/branch/fish_tank_branch_medium_stripped_bamboo");
            case DecorationType.SHIPWRECK_STRIPPED_OAK -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_oak");
            case DecorationType.SHIPWRECK_STRIPPED_SPRUCE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_spruce");
            case DecorationType.SHIPWRECK_STRIPPED_BIRCH -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_birch");
            case DecorationType.SHIPWRECK_STRIPPED_JUNGLE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_jungle");
            case DecorationType.SHIPWRECK_STRIPPED_ACACIA -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_acacia");
            case DecorationType.SHIPWRECK_STRIPPED_DARK_OAK -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_dark_oak");
            case DecorationType.SHIPWRECK_STRIPPED_MANGROVE -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_mangrove");
            case DecorationType.SHIPWRECK_STRIPPED_CHERRY -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_cherry");
            case DecorationType.SHIPWRECK_STRIPPED_BAMBOO -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_shipwreck_stripped_bamboo");
            case DecorationType.TOWER_STONE_BRICKS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_tower_stone_bricks");
            case DecorationType.TOWER_MOSSY_STONE_BRICKS -> new ResourceLocation(modId, "block/fishtank/deco/structures/fish_tank_tower_mossy_stone_bricks");
            case DecorationType.STRUCTURE_CAVE_PART -> null;
            case DecorationType.STRUCTURE_SHIPWRECK_PART -> null;
            case DecorationType.STRUCTURE_TOWER_PART -> null;
            default -> null;
        };
    }
}

