/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.datagen.custom;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import org.slf4j.Logger;

public class RandomFishPool {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<EntityType<? extends Mob>> RANDOM_FISH_POOL = new ArrayList<EntityType<? extends Mob>>();
    private static boolean isInitialized = false;
    private static final TagKey<EntityType<?>> MINECRAFT_FISHES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft", "fishes"));
    private static final TagKey<EntityType<?>> FORGE_FISH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge", "fish"));
    private static final TagKey<EntityType<?>> C_FISH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("c", "fish"));

    public static synchronized void init(MinecraftServer server) {
        if (isInitialized) {
            return;
        }
        LOGGER.info("Initializing RandomFishPool for the first time...");
        RANDOM_FISH_POOL.clear();
        RandomFishPool.addFishToPool(EntityType.f_20556_);
        RandomFishPool.addFishToPool(EntityType.f_20519_);
        RandomFishPool.addFishToPool(EntityType.f_20489_);
        RandomFishPool.addFishToPool(EntityType.f_20516_);
        RandomFishPool.addFishToPool(EntityType.f_147039_);
        RandomFishPool.addFishToPool(EntityType.f_20490_);
        Registry registry = server.m_206579_().m_175515_(Registries.f_256939_);
        RandomFishPool.addFromTag(registry, MINECRAFT_FISHES);
        RandomFishPool.addFromTag(registry, FORGE_FISH);
        RandomFishPool.addFromTag(registry, C_FISH);
        LOGGER.info("RandomFishPool initialized with {} total entities.", (Object)RANDOM_FISH_POOL.size());
        isInitialized = true;
    }

    private static void addFromTag(Registry<EntityType<?>> registry, TagKey<EntityType<?>> tagKey) {
        registry.m_206058_(tagKey).forEach(holder -> RandomFishPool.addFishToPool((EntityType)holder.m_203334_()));
    }

    public static synchronized List<EntityType<? extends Mob>> getFishPool() {
        if (!isInitialized) {
            LOGGER.error("FATAL: getFishPool() was called before RandomFishPool was initialized!");
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(RANDOM_FISH_POOL);
    }

    public static synchronized void addFishToPool(EntityType<?> type) {
        if (type == null) {
            return;
        }
        try {
            EntityType<?> mobType = type;
            if (!RANDOM_FISH_POOL.contains(mobType)) {
                RANDOM_FISH_POOL.add(mobType);
                LOGGER.debug("Added {} to RandomFishPool.", (Object)type.m_20675_());
            }
        }
        catch (ClassCastException e) {
            LOGGER.warn("Attempted to add non-mob entity type to fish pool: {}", (Object)type.m_20675_());
        }
    }
}

