/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.item.custom;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.FishTankBlock;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.FishTankBlockEntity;
import net.mint_gaming_studios.betterfishtanksmod.datagen.custom.FishClassifier;
import org.jetbrains.annotations.Nullable;

public class FishBagItem
extends Item {
    private static final String STORED_ENTITY_KEY = "StoredEntity";

    public FishBagItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (!level.f_46443_) {
            if (player.m_6144_()) {
                FishTankBlockEntity fishTank;
                BlockEntity blockEntity;
                BlockHitResult rayTraceResult = (BlockHitResult)player.m_19907_(15.0, 0.0f, false);
                BlockPos lookPos = rayTraceResult.m_82425_();
                BlockState lookState = level.m_8055_(lookPos);
                if (lookState.m_60734_() instanceof FishTankBlock && (blockEntity = level.m_7702_(lookPos)) instanceof FishTankBlockEntity && (fishTank = (FishTankBlockEntity)blockEntity).releaseFishFromBag(player, hand)) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return this.releaseEntity(level, player, stack, tag);
            }
            return this.captureEntity(level, player, stack, tag);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    private InteractionResultHolder<ItemStack> releaseEntity(Level level, Player player, ItemStack stack, CompoundTag tag) {
        CompoundTag entityTag;
        Optional<Entity> entityOptional;
        if (tag.m_128441_(STORED_ENTITY_KEY) && (entityOptional = Optional.ofNullable(EntityType.m_20645_((CompoundTag)(entityTag = tag.m_128469_(STORED_ENTITY_KEY)), (Level)level, e -> e))).isPresent()) {
            Entity entity = entityOptional.get();
            Vec3 spawnPosition = this.getSpawnPosition(player);
            entity.m_6034_(spawnPosition.f_82479_, spawnPosition.f_82480_ + 0.5, spawnPosition.f_82481_);
            level.m_7967_(entity);
            tag.m_128473_(STORED_ENTITY_KEY);
            stack.m_41751_(tag);
            player.m_5661_((Component)Component.m_237110_((String)"message.betterfishtanks.released", (Object[])new Object[]{entity.m_6095_().m_20676_()}), true);
            player.m_5496_(SoundEvents.f_11917_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> captureEntity(Level level, Player player, ItemStack stack, CompoundTag tag) {
        if (tag.m_128441_(STORED_ENTITY_KEY)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.betterfishtanks.bag_full"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        double radius = 5.0;
        AABB searchBox = player.m_20191_().m_82400_(radius);
        List nearbyEntities = level.m_6443_(Mob.class, searchBox, entity -> entity != null && entity.m_6084_());
        Vec3 lookVec = player.m_20154_();
        Vec3 eyePos = player.m_146892_();
        Mob bestTarget = null;
        double maxDot = -1.0;
        for (Mob entity2 : nearbyEntities) {
            Vec3 toEntity = entity2.m_146892_().m_82546_(eyePos).m_82541_();
            double dot = lookVec.m_82526_(toEntity);
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            bestTarget = entity2;
        }
        double CATCH_THRESHOLD = 0.85;
        if (bestTarget != null && maxDot > 0.85) {
            if (this.canCapture(bestTarget)) {
                Mob target = bestTarget;
                CompoundTag entityData = new CompoundTag();
                target.m_20240_(entityData);
                entityData.m_128359_("id", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
                tag.m_128365_(STORED_ENTITY_KEY, (Tag)entityData);
                stack.m_41751_(tag);
                target.m_142687_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
                player.m_5661_((Component)Component.m_237110_((String)"message.betterfishtanks.caught", (Object[])new Object[]{target.m_6095_().m_20676_()}), true);
                player.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
            }
            player.m_5661_((Component)Component.m_237110_((String)"message.betterfishtanks.cannot_catch", (Object[])new Object[]{bestTarget.m_6095_().m_20676_()}), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.betterfishtanks.no_target"), true);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag entityTag;
        ResourceLocation entityId;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(STORED_ENTITY_KEY) && (entityId = ResourceLocation.m_135820_((String)(entityTag = tag.m_128469_(STORED_ENTITY_KEY)).m_128461_("id"))) != null) {
            BuiltInRegistries.f_256780_.m_6612_(entityId).ifPresent(entityType -> {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.betterfishtanks.fish", (Object[])new Object[]{entityType.m_20676_()}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xA0A0A0))));
                if (entityType == EntityType.f_20489_) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.betterfishtanks.tropical_variant").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xA0A0A0))));
                }
            });
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_(STORED_ENTITY_KEY);
    }

    private boolean canCapture(Mob entity) {
        return FishClassifier.isCatchable((Entity)entity);
    }

    private Vec3 getSpawnPosition(Player player) {
        Vec3 direction = player.m_20154_();
        Vec3 playerPos = player.m_20182_();
        double offsetX = Math.abs(direction.f_82479_) > Math.abs(direction.f_82481_) ? Math.signum(direction.f_82479_) : 0.0;
        double offsetZ = Math.abs(direction.f_82481_) >= Math.abs(direction.f_82479_) ? Math.signum(direction.f_82481_) : 0.0;
        return new Vec3(playerPos.f_82479_ + offsetX, playerPos.f_82480_, playerPos.f_82481_ + offsetZ);
    }

    public static CompoundTag getFishData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(STORED_ENTITY_KEY)) {
            return tag.m_128469_(STORED_ENTITY_KEY);
        }
        return null;
    }

    public static void removeFish(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(STORED_ENTITY_KEY);
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }
}

