/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.jei;

import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.mint_gaming_studios.betterfishtanksmod.block.ModBlocks;

public class AquaristTableEggObtainingCategory
implements IRecipeCategory<EggObtainingRecipeWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("betterfishtanks", "aquarist_egg_obtaining");
    public static final RecipeType<EggObtainingRecipeWrapper> RECIPE_TYPE = new RecipeType(UID, EggObtainingRecipeWrapper.class);
    private final IDrawable background;
    private final IDrawable icon;

    public AquaristTableEggObtainingCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.AQUARIST_TABLE.get()));
    }

    public RecipeType<EggObtainingRecipeWrapper> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"betterfishtanks.jei.aquarist_table.egg_obtaining");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EggObtainingRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 79, 20).addItemStack(recipe.getEggItem());
    }

    public void draw(EggObtainingRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MutableComponent chanceText = Component.m_237115_((String)recipe.getChanceTextKey());
        int chanceTextWidth = font.m_92852_((FormattedText)chanceText);
        int chanceTextX = (this.background.getWidth() - chanceTextWidth) / 2;
        int chanceTextY = 40;
        guiGraphics.m_280614_(font, (Component)chanceText, chanceTextX, chanceTextY, 0xFFFFFF, true);
        float scale = 0.75f;
        int centerX = this.background.getWidth() / 2;
        int startY = chanceTextY + 12;
        MutableComponent infoTextLine1 = Component.m_237115_((String)"betterfishtanks.jei.aquarist_table.egg_obtaining.info_line1");
        int unscaledTextWidth1 = font.m_92852_((FormattedText)infoTextLine1);
        float scaledTextWidth1 = (float)unscaledTextWidth1 * scale;
        float drawX1 = (float)centerX - scaledTextWidth1 / 2.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(drawX1, (float)startY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280614_(font, (Component)infoTextLine1, 0, 0, 0xAAAAAA, false);
        guiGraphics.m_280168_().m_85849_();
        MutableComponent infoTextLine2 = Component.m_237115_((String)"betterfishtanks.jei.aquarist_table.egg_obtaining.info_line2");
        int unscaledTextWidth2 = font.m_92852_((FormattedText)infoTextLine2);
        float scaledTextWidth2 = (float)unscaledTextWidth2 * scale;
        float drawX2 = (float)centerX - scaledTextWidth2 / 2.0f;
        float f = startY;
        Objects.requireNonNull(font);
        float drawY2 = f + 9.0f * scale + 2.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(drawX2, drawY2, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280614_(font, (Component)infoTextLine2, 0, 0, 0xAAAAAA, false);
        guiGraphics.m_280168_().m_85849_();
    }

    public static class EggObtainingRecipeWrapper {
        private final ItemStack eggItem;
        private final String chanceTextKey;

        public EggObtainingRecipeWrapper(ItemStack eggItem, String chanceTextKey) {
            this.eggItem = eggItem;
            this.chanceTextKey = chanceTextKey;
        }

        public ItemStack getEggItem() {
            return this.eggItem;
        }

        public String getChanceTextKey() {
            return this.chanceTextKey;
        }
    }
}

