/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.mint_gaming_studios.betterfishtanksmod.item.ModItems;
import net.mint_gaming_studios.betterfishtanksmod.jei.AquaristTableDecoRecipeCategory;
import net.mint_gaming_studios.betterfishtanksmod.jei.AquaristTableEggObtainingCategory;
import net.mint_gaming_studios.betterfishtanksmod.jei.AquaristTableEggRecipeCategory;
import net.mint_gaming_studios.betterfishtanksmod.jei.AquaristTableFoodRecipeCategory;
import net.mint_gaming_studios.betterfishtanksmod.loot.FishClassLootManager;
import net.mint_gaming_studios.betterfishtanksmod.recipe.AquaristTableRecipes;

@JeiPlugin
public class BetterFishtanksJEIPlugin
implements IModPlugin {
    public static final RecipeType<AquaristTableDecoRecipeCategory.AquaristTableDecoRecipeWrapper> DECO_TYPE = AquaristTableDecoRecipeCategory.RECIPE_TYPE;
    public static final RecipeType<AquaristTableFoodRecipeCategory.FoodRecipeWrapper> FOOD_TYPE = new RecipeType(AquaristTableFoodRecipeCategory.UID, AquaristTableFoodRecipeCategory.FoodRecipeWrapper.class);
    public static final RecipeType<AquaristTableEggRecipeCategory.EggRecipeWrapper> EGG_TYPE = AquaristTableEggRecipeCategory.RECIPE_TYPE;
    public static final RecipeType<AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper> EGG_OBTAINING_TYPE = AquaristTableEggObtainingCategory.RECIPE_TYPE;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("betterfishtanks", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AquaristTableDecoRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new AquaristTableFoodRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new AquaristTableEggRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new AquaristTableEggObtainingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List decoRecipes = AquaristTableRecipes.DECO_RECIPES.stream().map(recipe -> new AquaristTableDecoRecipeCategory.AquaristTableDecoRecipeWrapper(recipe.getInput().m_7968_(), recipe.getOutput())).collect(Collectors.toList());
        registration.addRecipes(DECO_TYPE, decoRecipes);
        List<AquaristTableFoodRecipeCategory.FoodRecipeWrapper> foodRecipes = AquaristTableFoodRecipeCategory.getFoodRecipes();
        registration.addRecipes(FOOD_TYPE, foodRecipes);
        FishClassLootManager.generateLoot();
        ArrayList<AquaristTableEggRecipeCategory.EggRecipeWrapper> eggLootRecipes = new ArrayList<AquaristTableEggRecipeCategory.EggRecipeWrapper>();
        this.addEggLootRecipe(eggLootRecipes, (Item)ModItems.COMMON_FISH_EGG.get());
        this.addEggLootRecipe(eggLootRecipes, (Item)ModItems.UNCOMMON_FISH_EGG.get());
        this.addEggLootRecipe(eggLootRecipes, (Item)ModItems.RARE_FISH_EGG.get());
        this.addEggLootRecipe(eggLootRecipes, (Item)ModItems.EPIC_FISH_EGG.get());
        this.addEggLootRecipe(eggLootRecipes, (Item)ModItems.EXOTIC_FISH_EGG.get());
        this.addEggLootRecipe(eggLootRecipes, (Item)ModItems.LEGENDARY_FISH_EGG.get());
        registration.addRecipes(EGG_TYPE, eggLootRecipes);
        ArrayList<AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper> eggObtainingRecipes = new ArrayList<AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper>();
        eggObtainingRecipes.add(new AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper(new ItemStack((ItemLike)ModItems.COMMON_FISH_EGG.get()), "betterfishtanks.jei.aquarist_table.egg_obtaining.common"));
        eggObtainingRecipes.add(new AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper(new ItemStack((ItemLike)ModItems.UNCOMMON_FISH_EGG.get()), "betterfishtanks.jei.aquarist_table.egg_obtaining.uncommon"));
        eggObtainingRecipes.add(new AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper(new ItemStack((ItemLike)ModItems.RARE_FISH_EGG.get()), "betterfishtanks.jei.aquarist_table.egg_obtaining.rare"));
        eggObtainingRecipes.add(new AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper(new ItemStack((ItemLike)ModItems.EPIC_FISH_EGG.get()), "betterfishtanks.jei.aquarist_table.egg_obtaining.epic"));
        eggObtainingRecipes.add(new AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper(new ItemStack((ItemLike)ModItems.EXOTIC_FISH_EGG.get()), "betterfishtanks.jei.aquarist_table.egg_obtaining.exotic"));
        eggObtainingRecipes.add(new AquaristTableEggObtainingCategory.EggObtainingRecipeWrapper(new ItemStack((ItemLike)ModItems.LEGENDARY_FISH_EGG.get()), "betterfishtanks.jei.aquarist_table.egg_obtaining.legendary"));
        registration.addRecipes(EGG_OBTAINING_TYPE, eggObtainingRecipes);
    }

    private void addEggLootRecipe(List<AquaristTableEggRecipeCategory.EggRecipeWrapper> recipeList, Item eggItem) {
        List<ItemStack> outputs;
        String fishClass = this.getFishClassForEggItem(new ItemStack((ItemLike)eggItem));
        if (fishClass != null && !(outputs = FishClassLootManager.getCombinedLootForClass(fishClass)).isEmpty()) {
            recipeList.add(new AquaristTableEggRecipeCategory.EggRecipeWrapper(new ItemStack((ItemLike)eggItem), outputs));
        }
    }

    private String getFishClassForEggItem(ItemStack eggItem) {
        if (eggItem.m_41720_() == ModItems.COMMON_FISH_EGG.get()) {
            return "common";
        }
        if (eggItem.m_41720_() == ModItems.UNCOMMON_FISH_EGG.get()) {
            return "uncommon";
        }
        if (eggItem.m_41720_() == ModItems.RARE_FISH_EGG.get()) {
            return "rare";
        }
        if (eggItem.m_41720_() == ModItems.EPIC_FISH_EGG.get()) {
            return "epic";
        }
        if (eggItem.m_41720_() == ModItems.EXOTIC_FISH_EGG.get()) {
            return "exotic";
        }
        if (eggItem.m_41720_() == ModItems.LEGENDARY_FISH_EGG.get()) {
            return "legendary";
        }
        return null;
    }

    private ItemStack getEggItemForClass(String fishClass) {
        return switch (fishClass) {
            case "common" -> new ItemStack((ItemLike)ModItems.COMMON_FISH_EGG.get());
            case "uncommon" -> new ItemStack((ItemLike)ModItems.UNCOMMON_FISH_EGG.get());
            case "rare" -> new ItemStack((ItemLike)ModItems.RARE_FISH_EGG.get());
            case "epic" -> new ItemStack((ItemLike)ModItems.EPIC_FISH_EGG.get());
            case "exotic" -> new ItemStack((ItemLike)ModItems.EXOTIC_FISH_EGG.get());
            case "legendary" -> new ItemStack((ItemLike)ModItems.LEGENDARY_FISH_EGG.get());
            default -> ItemStack.f_41583_;
        };
    }
}

