/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.mint_gaming_studios.betterfishtanksmod.network.ModMessages;
import net.mint_gaming_studios.betterfishtanksmod.network.PacketSetGuiType;
import net.mint_gaming_studios.betterfishtanksmod.screen.AquaristTableMenu;
import net.mint_gaming_studios.betterfishtanksmod.screen.guitype.GuiType;
import net.mint_gaming_studios.betterfishtanksmod.screen.widget.GuiButton;

public class AquaristTableScreen
extends AbstractContainerScreen<AquaristTableMenu> {
    private static final Map<GuiType, ResourceLocation> TEXTURES = new HashMap<GuiType, ResourceLocation>();
    private GuiButton decoButton;
    private GuiButton foodButton;
    private GuiButton eggButton;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public AquaristTableScreen(AquaristTableMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.decoButton = new GuiButton(x + 8, y + 8, 52, 23, 176, 169, button -> this.setGuiType(GuiType.DECO));
        this.foodButton = new GuiButton(x + 8, y + 31, 52, 23, 176, 29, button -> this.setGuiType(GuiType.FOOD));
        this.eggButton = new GuiButton(x + 8, y + 54, 52, 23, 176, 99, button -> this.setGuiType(GuiType.EGG));
        this.m_142416_((GuiEventListener)this.decoButton);
        this.m_142416_((GuiEventListener)this.foodButton);
        this.m_142416_((GuiEventListener)this.eggButton);
        this.updateButtonStates();
        this.displayRecipes = ((AquaristTableMenu)this.f_97732_).blockEntity.getGuiType() == GuiType.DECO;
    }

    private void setGuiType(GuiType guiType) {
        ModMessages.sendToServer(new PacketSetGuiType(((AquaristTableMenu)this.f_97732_).blockEntity.m_58899_(), guiType));
        ((AquaristTableMenu)this.f_97732_).blockEntity.setGuiType(guiType);
        this.updateButtonStates();
        this.displayRecipes = guiType == GuiType.DECO;
    }

    private void updateButtonStates() {
        GuiType currentGui = ((AquaristTableMenu)this.f_97732_).blockEntity.getGuiType();
        this.decoButton.f_93623_ = currentGui != GuiType.DECO;
        this.foodButton.f_93623_ = currentGui != GuiType.FOOD;
        this.eggButton.f_93623_ = currentGui != GuiType.EGG;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        GuiType currentGui = ((AquaristTableMenu)this.f_97732_).blockEntity.getGuiType();
        ResourceLocation texture = TEXTURES.get((Object)currentGui);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(texture, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (currentGui == GuiType.FOOD || currentGui == GuiType.EGG) {
            int progress = ((AquaristTableMenu)this.f_97732_).getScaledProgress();
            guiGraphics.m_280218_(texture, x + 130, y + 28, 176, 0, 8, progress);
        } else if (currentGui == GuiType.DECO) {
            int scrollbarX = x + 136;
            int scrollbarY = y + 16;
            int scrollbarHeight = 53;
            if (this.displayRecipes) {
                List<ItemStack> recipes = ((AquaristTableMenu)this.f_97732_).blockEntity.getAvailableDecoRecipes();
                int recipeCount = recipes.size();
                if (recipeCount > 9) {
                    guiGraphics.m_280218_(texture, scrollbarX, scrollbarY + (int)(41.0f * this.scrollOffs), 185, 0, 8, 14);
                } else {
                    guiGraphics.m_280218_(texture, scrollbarX, scrollbarY, 193, 0, 8, 14);
                }
                int recipeX = x + 90;
                int recipeY = y + 16;
                int selectedRecipe = ((AquaristTableMenu)this.f_97732_).getSelectedRecipeIndex();
                for (int i = this.startIndex; i < this.startIndex + 9 && i < recipeCount; ++i) {
                    int k = i - this.startIndex;
                    int l = recipeX + k % 3 * 15;
                    int i1 = recipeY + k / 3 * 16;
                    int j1 = 166;
                    if (i == selectedRecipe) {
                        j1 += 16;
                    } else if (pMouseX >= l && pMouseY >= i1 && pMouseX < l + 16 && pMouseY < i1 + 16) {
                        j1 += 32;
                    }
                    guiGraphics.m_280218_(texture, l, i1, 0, j1, 16, 16);
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_((float)(l + 1), (float)(i1 + 1), 50.0f);
                    guiGraphics.m_280168_().m_85841_(0.875f, 0.875f, 1.0f);
                    guiGraphics.m_280480_(recipes.get(i), 0, 0);
                    guiGraphics.m_280168_().m_85849_();
                }
            }
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (((AquaristTableMenu)this.f_97732_).blockEntity.getGuiType() == GuiType.DECO) {
            this.scrolling = false;
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            if (this.displayRecipes) {
                int recipeX = x + 90;
                int recipeY = y + 16;
                List<ItemStack> recipes = ((AquaristTableMenu)this.f_97732_).blockEntity.getAvailableDecoRecipes();
                for (int i = this.startIndex; i < this.startIndex + 9 && i < recipes.size(); ++i) {
                    int k = i - this.startIndex;
                    double d0 = pMouseX - (double)(recipeX + k % 3 * 15);
                    double d1 = pMouseY - (double)(recipeY + k / 3 * 16);
                    if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 16.0) || !((AquaristTableMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, i)) continue;
                    Minecraft.m_91087_().f_91072_.m_105208_(((AquaristTableMenu)this.f_97732_).f_38840_, i);
                    return true;
                }
                int scrollbarX = x + 136;
                int scrollbarY = y + 16;
                if (pMouseX >= (double)scrollbarX && pMouseX < (double)(scrollbarX + 8) && pMouseY >= (double)scrollbarY && pMouseY < (double)(scrollbarY + 53)) {
                    this.scrolling = true;
                }
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && ((AquaristTableMenu)this.f_97732_).blockEntity.getGuiType() == GuiType.DECO && this.displayRecipes) {
            int i = (this.f_96544_ - this.f_97727_) / 2 + 16;
            int j = i + 53;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 3;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (((AquaristTableMenu)this.f_97732_).blockEntity.getGuiType() == GuiType.DECO && this.displayRecipes) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 3;
        }
        return true;
    }

    private int getOffscreenRows() {
        return (((AquaristTableMenu)this.f_97732_).blockEntity.getAvailableDecoRecipes().size() + 3 - 1) / 3 - 3;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
    }

    static {
        TEXTURES.put(GuiType.DECO, new ResourceLocation("betterfishtanks", "textures/gui/aquarist_station/aquarist_station_gui_deco.png"));
        TEXTURES.put(GuiType.FOOD, new ResourceLocation("betterfishtanks", "textures/gui/aquarist_station/aquarist_station_gui_food.png"));
        TEXTURES.put(GuiType.EGG, new ResourceLocation("betterfishtanks", "textures/gui/aquarist_station/aquarist_station_gui_egg.png"));
    }
}

