/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.screen;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mint_gaming_studios.betterfishtanksmod.block.ModBlocks;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.decor.DecorationType;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.FishTankBlockEntity;
import net.mint_gaming_studios.betterfishtanksmod.config.ModConfig;
import net.mint_gaming_studios.betterfishtanksmod.item.ModItems;
import net.mint_gaming_studios.betterfishtanksmod.screen.ModMenuTypes;
import org.jetbrains.annotations.NotNull;

public class FishTankMenu
extends AbstractContainerMenu {
    public final FishTankBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private final ContainerData data;

    public FishTankMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(8));
    }

    public FishTankMenu(int containerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.FISH_TANK_MENU.get(), containerId);
        FishTankMenu.m_38869_((Container)inv, (int)23);
        this.blockEntity = (FishTankBlockEntity)entity;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_());
        this.data = data;
        this.m_38897_(new Slot((Container)this.blockEntity, 0, 143, 17));
        int i = 0;
        while (i < 20) {
            int yPos;
            int xPos;
            int slotIndex = 1 + i;
            int indexOnPage = i % 5;
            if (indexOnPage == 0) {
                xPos = 17;
                yPos = 17;
            } else if (indexOnPage == 1) {
                xPos = 17;
                yPos = 35;
            } else if (indexOnPage == 2) {
                xPos = 35;
                yPos = 26;
            } else if (indexOnPage == 3) {
                xPos = 35;
                yPos = 44;
            } else {
                xPos = 17;
                yPos = 53;
            }
            final int finalI = i++;
            this.m_38897_(new Slot((Container)this.blockEntity, slotIndex, xPos, yPos){

                public boolean m_6659_() {
                    if (finalI >= FishTankMenu.this.blockEntity.getMaxDecoSlots()) {
                        return false;
                    }
                    int slotPage = finalI / 5;
                    return slotPage == FishTankMenu.this.getCurrentPage();
                }

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return FishTankMenu.this.blockEntity.getDecorationTypeFromItemStack(stack) != DecorationType.NONE;
                }

                public int m_6641_() {
                    return 1;
                }
            });
        }
        this.m_38897_(new Slot((Container)this.blockEntity, 21, 143, 58){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }
        });
        this.m_38897_(new Slot((Container)this.blockEntity, 22, 88, 49){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_150930_(Items.f_41830_) || stack.m_150930_(Items.f_41832_) || stack.m_150930_(Items.f_41831_);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 142));
        }
        this.m_38884_(data);
    }

    public boolean needsFood() {
        return (Boolean)ModConfig.Server.REQUIRE_FOOD.get();
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.blockEntity.synchronizeDecorations();
    }

    public boolean isBrewing() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int arrowHeight = 28;
        if (maxProgress <= 0 || progress <= 0) {
            return 0;
        }
        int doneProgress = maxProgress - progress;
        return doneProgress * arrowHeight / maxProgress;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int containerSlots;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int playerInvStart = containerSlots = 23;
            int playerHotbarStart = playerInvStart + 27;
            int playerInvEnd = playerHotbarStart + 9;
            if (index < containerSlots) {
                if (!this.m_38903_(stack, playerInvStart, playerInvEnd, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                boolean handled = false;
                if (stack.m_150930_(Items.f_42576_) || stack.m_150930_((Item)ModItems.FOOD_DRIEDKELP_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_FLAKES_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_MINISHRIMP_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_PELLETS_CONTAINER.get())) {
                    if (this.m_38903_(stack, 0, 1, false)) {
                        handled = true;
                    }
                } else if (stack.m_150930_(Items.f_41830_) || stack.m_150930_(Items.f_41832_) || stack.m_150930_(Items.f_41831_)) {
                    if (this.m_38903_(stack, 22, 23, false)) {
                        handled = true;
                    }
                } else if (this.blockEntity.getDecorationTypeFromItemStack(stack) != DecorationType.NONE && this.m_38903_(stack, 1, 21, false)) {
                    handled = true;
                }
                if (!handled && (index >= playerInvStart && index < playerHotbarStart ? !this.m_38903_(stack, playerHotbarStart, playerInvEnd, false) : index >= playerHotbarStart && index < playerInvEnd && !this.m_38903_(stack, playerInvStart, playerHotbarStart, false))) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return FishTankMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ModBlocks.FISH_TANK_BLOCK.get()));
    }

    public int getFishCount() {
        return this.data.m_6413_(2);
    }

    public int getFoodLevel() {
        return this.data.m_6413_(3);
    }

    public int getMaxFoodLevel() {
        return this.data.m_6413_(4);
    }

    public int getFloorBlockCount() {
        return this.data.m_6413_(5);
    }

    public int getMaxDecoSlots() {
        return this.data.m_6413_(6);
    }

    public int getCurrentPage() {
        return this.data.m_6413_(7);
    }

    public void setCurrentPage(int page) {
        this.data.m_8050_(7, page);
    }

    public int getTotalPages() {
        int maxSlots = this.getMaxDecoSlots();
        if (maxSlots <= 0) {
            return 1;
        }
        return (maxSlots + 5 - 1) / 5;
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPage() > 0;
    }

    public boolean hasNextPage() {
        return (this.getCurrentPage() + 1) * 5 < this.getMaxDecoSlots();
    }
}

