/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.FishTankBlockEntity;
import net.mint_gaming_studios.betterfishtanksmod.network.ModMessages;
import net.mint_gaming_studios.betterfishtanksmod.network.PacketChangeFishTankPage;
import net.mint_gaming_studios.betterfishtanksmod.screen.FishTankMenu;
import net.mint_gaming_studios.betterfishtanksmod.screen.widget.ImageButton;

public class FishTankScreen
extends AbstractContainerScreen<FishTankMenu> {
    private static final ResourceLocation TEXTURE_NO_FOOD = new ResourceLocation("betterfishtanks", "textures/gui/fish_tank_gui.png");
    private static final ResourceLocation TEXTURE_WITH_FOOD = new ResourceLocation("betterfishtanks", "textures/gui/fish_tank_gui_food.png");
    public final FishTankBlockEntity blockEntity;
    private ImageButton prevPageButton;
    private ImageButton nextPageButton;

    public FishTankScreen(FishTankMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.blockEntity = menu.blockEntity;
        this.f_97727_ = 166;
        this.f_97726_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = -1000;
        this.f_97730_ = -1000;
        this.prevPageButton = new ImageButton(this.f_97735_ + 36, this.f_97736_ + 62, 7, 9, 176, 69, 9, TEXTURE_WITH_FOOD, true, button -> ModMessages.sendToServer(new PacketChangeFishTankPage(this.blockEntity.m_58899_(), ((FishTankMenu)this.f_97732_).getCurrentPage() - 1)));
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.nextPageButton = new ImageButton(this.f_97735_ + 44, this.f_97736_ + 62, 7, 9, 176, 96, 9, TEXTURE_WITH_FOOD, false, button -> ModMessages.sendToServer(new PacketChangeFishTankPage(this.blockEntity.m_58899_(), ((FishTankMenu)this.f_97732_).getCurrentPage() + 1)));
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.updateButtonVisibility();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation texture = ((FishTankMenu)this.f_97732_).needsFood() ? TEXTURE_WITH_FOOD : TEXTURE_NO_FOOD;
        guiGraphics.m_280218_(texture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgressArrow(guiGraphics, texture);
        if (((FishTankMenu)this.f_97732_).needsFood()) {
            this.renderFoodBar(guiGraphics);
        }
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, ResourceLocation texture) {
        int progress = ((FishTankMenu)this.f_97732_).getScaledProgress();
        guiGraphics.m_280218_(texture, this.f_97735_ + 160, this.f_97736_ + 32, 176, 0, 9, progress);
    }

    private void renderFoodBar(GuiGraphics guiGraphics) {
        int foodBarHeight;
        int foodLevel = ((FishTankMenu)this.f_97732_).getFoodLevel();
        int maxFoodLevel = ((FishTankMenu)this.f_97732_).getMaxFoodLevel();
        if (maxFoodLevel > 0 && (foodBarHeight = (int)Math.ceil((float)foodLevel / (float)maxFoodLevel * 37.0f)) > 0) {
            int y = this.f_97736_ + 32 + (37 - foodBarHeight);
            int v = 67 - foodBarHeight;
            guiGraphics.m_280218_(TEXTURE_WITH_FOOD, this.f_97735_ + 127, y, 176, v, 9, foodBarHeight);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int fishCount = ((FishTankMenu)this.f_97732_).getFishCount();
        String fishText = "Fish: " + fishCount;
        int fishTextWidth = this.f_96547_.m_92895_(fishText);
        guiGraphics.m_280056_(this.f_96547_, fishText, x + 86 + (18 - fishTextWidth) / 2, y + 15, 0x404040, false);
        String waterText = "Water: " + ((FishTankMenu)this.f_97732_).blockEntity.getFormattedWaterLevel();
        guiGraphics.m_280056_(this.f_96547_, waterText, this.f_97735_ + 8, this.f_97736_ + 73, 0x404040, false);
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        if (this.prevPageButton != null) {
            this.prevPageButton.f_93623_ = ((FishTankMenu)this.f_97732_).hasPreviousPage();
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.f_93623_ = ((FishTankMenu)this.f_97732_).hasNextPage();
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtonVisibility();
    }

    public void onPageChanged() {
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public FishTankMenu getMenu() {
        return (FishTankMenu)this.f_97732_;
    }
}

