/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.mint_gaming_studios.betterfishtanksmod.BetterFishtanksMod;

public class TextureGeneration {
    public static final int PRIMARY_GREY = 10;
    public static final int SECONDARY_GREY = 20;
    public static final Map<String, String> MATERIAL_TO_TEXTURE_MAP = Map.ofEntries(Map.entry("stone_bricks", "stone_bricks"), Map.entry("mossy_stone_bricks", "mossy_stone_bricks"), Map.entry("stone", "stone"), Map.entry("tuff", "tuff"), Map.entry("calcite", "calcite"), Map.entry("diorite", "diorite"), Map.entry("granite", "granite"), Map.entry("andesite", "andesite"), Map.entry("deepslate", "deepslate"), Map.entry("dripstone_block", "dripstone_block"), Map.entry("lapis", "lapis_block"), Map.entry("diamond", "diamond_block"), Map.entry("emerald", "emerald_block"), Map.entry("amethyst", "amethyst_block"), Map.entry("redstone", "redstone_block"), Map.entry("stripped_oak", "stripped_oak_log"), Map.entry("stripped_birch", "stripped_birch_log"), Map.entry("stripped_acacia", "stripped_acacia_log"), Map.entry("stripped_bamboo", "stripped_bamboo_block"), Map.entry("stripped_cherry", "stripped_cherry_log"), Map.entry("stripped_jungle", "stripped_jungle_log"), Map.entry("stripped_spruce", "stripped_spruce_log"), Map.entry("stripped_dark_oak", "stripped_dark_oak_log"), Map.entry("stripped_mangrove", "stripped_mangrove_log"), Map.entry("oak", "oak_log"), Map.entry("birch", "birch_log"), Map.entry("acacia", "acacia_log"), Map.entry("bamboo", "bamboo_block"), Map.entry("cherry", "cherry_log"), Map.entry("jungle", "jungle_log"), Map.entry("spruce", "spruce_log"), Map.entry("dark_oak", "dark_oak_log"), Map.entry("mangrove", "mangrove_log"));
    public static final List<String> SORTED_MATERIAL_KEYS = MATERIAL_TO_TEXTURE_MAP.keySet().stream().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
    public static final List<String> SORTED_BASE_NAMES = Arrays.asList("structure_cave", "tiny_stone", "small_stone", "tiny_branch", "small_branch", "medium_branch", "shipwreck", "tower").stream().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());

    public static String getBaseName(String decoName) {
        for (String b : SORTED_BASE_NAMES) {
            if (!decoName.startsWith(b)) continue;
            return b;
        }
        return "";
    }

    public static List<String> findMaterialKeywords(String decoName) {
        String baseName = TextureGeneration.getBaseName(decoName);
        if (baseName.isEmpty()) {
            return Collections.emptyList();
        }
        String materialPart = decoName.substring(baseName.length());
        if (materialPart.startsWith("_")) {
            materialPart = materialPart.substring(1);
        }
        ArrayList<String> found = new ArrayList<String>();
        String remainingMaterials = materialPart;
        while (!remainingMaterials.isEmpty()) {
            boolean foundMatch = false;
            for (String keyword : SORTED_MATERIAL_KEYS) {
                if (!remainingMaterials.startsWith(keyword)) continue;
                found.add(keyword);
                remainingMaterials = remainingMaterials.substring(keyword.length());
                if (remainingMaterials.startsWith("_")) {
                    remainingMaterials = remainingMaterials.substring(1);
                }
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            break;
        }
        return found;
    }

    public static void generate(NativeImage baseImage, Map<Integer, NativeImage> materialImages, String outputName, String outputType) {
        try (NativeImage outputImage = new NativeImage(baseImage.m_84982_(), baseImage.m_85084_(), false);){
            for (int y = 0; y < baseImage.m_85084_(); ++y) {
                for (int x = 0; x < baseImage.m_84982_(); ++x) {
                    int pixelColor = baseImage.m_84985_(x, y);
                    int red = pixelColor & 0xFF;
                    NativeImage sourceImage = materialImages.get(red);
                    if (sourceImage != null) {
                        int sourcePixelColor = sourceImage.m_84985_(x % sourceImage.m_84982_(), y % sourceImage.m_85084_());
                        outputImage.m_84988_(x, y, sourcePixelColor);
                        continue;
                    }
                    outputImage.m_84988_(x, y, pixelColor);
                }
            }
            DynamicTexture dynamicTexture = new DynamicTexture(outputImage);
            ResourceLocation newTextureLocation = new ResourceLocation("betterfishtanks", "item/deco/" + outputType + "/" + outputName);
            Minecraft.m_91087_().m_91097_().m_118495_(newTextureLocation, (AbstractTexture)dynamicTexture);
        }
        catch (Exception e) {
            BetterFishtanksMod.LOGGER.error("Failed to generate texture for '{}'", (Object)outputName, (Object)e);
        }
    }
}

