/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MobRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"mint_lib");
    private static final Map<RegistryObject<? extends EntityType<? extends Mob>>, Supplier<AttributeSupplier.Builder>> MOB_ATTRIBUTES = new HashMap<RegistryObject<? extends EntityType<? extends Mob>>, Supplier<AttributeSupplier.Builder>>();
    private static final List<Consumer<EntityRenderersEvent.RegisterRenderers>> RENDERER_REGISTRARS = new ArrayList<Consumer<EntityRenderersEvent.RegisterRenderers>>();

    public static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, Supplier<EntityType.Builder<T>> builder, Supplier<AttributeSupplier.Builder> attributeSupplier, EntityRendererProvider<T> rendererProvider, int primaryColor, int secondaryColor, DeferredRegister<Item> itemRegister) {
        RegistryObject entityType = ENTITY_TYPES.register(name, () -> ((EntityType.Builder)builder.get()).m_20712_(name));
        itemRegister.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)entityType, primaryColor, secondaryColor, new Item.Properties()));
        MOB_ATTRIBUTES.put((RegistryObject<? extends EntityType<? extends Mob>>)entityType, attributeSupplier);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RENDERER_REGISTRARS.add(event -> event.registerEntityRenderer((EntityType)entityType.get(), rendererProvider)));
        return entityType;
    }

    public static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, Supplier<EntityType.Builder<T>> builder, Supplier<AttributeSupplier.Builder> attributeSupplier, EntityRendererProvider<T> rendererProvider, Supplier<Item> spawnEggSupplier, DeferredRegister<Item> itemRegister) {
        RegistryObject entityType = ENTITY_TYPES.register(name, () -> ((EntityType.Builder)builder.get()).m_20712_(name));
        itemRegister.register(name + "_spawn_egg", spawnEggSupplier);
        MOB_ATTRIBUTES.put((RegistryObject<? extends EntityType<? extends Mob>>)entityType, attributeSupplier);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RENDERER_REGISTRARS.add(event -> event.registerEntityRenderer((EntityType)entityType.get(), rendererProvider)));
        return entityType;
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        for (Map.Entry<RegistryObject<? extends EntityType<? extends Mob>>, Supplier<AttributeSupplier.Builder>> entry : MOB_ATTRIBUTES.entrySet()) {
            event.put((EntityType)entry.getKey().get(), entry.getValue().get().m_22265_());
        }
    }

    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        RENDERER_REGISTRARS.forEach(registrar -> registrar.accept(event));
    }
}

