/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.entity.presets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SmallFlyingMobPreset<T extends Mob> {
    private final String name;
    private final Supplier<EntityType<T>> entityTypeSupplier;
    private final BiFunction<EntityType<T>, Level, T> entityConstructor;
    private final MobBehavior mobBehavior;
    private final double attackDamage;
    private final Map<String, ResourceLocation> animations;
    private final Map<SoundEventTrigger, Supplier<SoundEvent>> soundEvents;
    private final Map<EquipmentSlot, ItemStack> equipment;
    private final ResourceLocation lootTable;

    private SmallFlyingMobPreset(Builder<T> builder) {
        this.name = builder.name;
        this.entityTypeSupplier = builder.entityTypeSupplier;
        this.entityConstructor = builder.entityConstructor;
        this.mobBehavior = builder.mobBehavior;
        this.attackDamage = builder.attackDamage;
        this.animations = builder.animations;
        this.soundEvents = builder.soundEvents;
        this.equipment = builder.equipment;
        this.lootTable = builder.lootTable;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<EntityType<T>> getEntityTypeSupplier() {
        return this.entityTypeSupplier;
    }

    public BiFunction<EntityType<T>, Level, T> getEntityConstructor() {
        return this.entityConstructor;
    }

    public MobBehavior getMobBehavior() {
        return this.mobBehavior;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public Map<String, ResourceLocation> getAnimations() {
        return this.animations;
    }

    public Map<SoundEventTrigger, Supplier<SoundEvent>> getSoundEvents() {
        return this.soundEvents;
    }

    public Map<EquipmentSlot, ItemStack> getEquipment() {
        return this.equipment;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public static AttributeSupplier.Builder createSmallFlyingMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 1.0);
    }

    public static class Builder<T extends Mob> {
        private final String name;
        private final Supplier<EntityType<T>> entityTypeSupplier;
        private final BiFunction<EntityType<T>, Level, T> entityConstructor;
        private MobBehavior mobBehavior = MobBehavior.PASSIVE;
        private double attackDamage = 1.0;
        private Map<String, ResourceLocation> animations = new HashMap<String, ResourceLocation>();
        private Map<SoundEventTrigger, Supplier<SoundEvent>> soundEvents = new HashMap<SoundEventTrigger, Supplier<SoundEvent>>();
        private Map<EquipmentSlot, ItemStack> equipment = new HashMap<EquipmentSlot, ItemStack>();
        private ResourceLocation lootTable = null;

        public Builder(String name, Supplier<EntityType<T>> entityTypeSupplier, BiFunction<EntityType<T>, Level, T> entityConstructor) {
            this.name = name;
            this.entityTypeSupplier = entityTypeSupplier;
            this.entityConstructor = entityConstructor;
            this.animations.put("fly", new ResourceLocation("minecraft", "animations/small_flying_mob.fly.json"));
            this.animations.put("idle", new ResourceLocation("minecraft", "animations/small_flying_mob.idle.json"));
            this.animations.put("death", new ResourceLocation("minecraft", "animations/small_flying_mob.death.json"));
            this.animations.put("attack", new ResourceLocation("minecraft", "animations/small_flying_mob.attack.json"));
            this.animations.put("hurt", new ResourceLocation("minecraft", "animations/small_flying_mob.hurt.json"));
        }

        public Builder<T> mobBehavior(MobBehavior mobBehavior) {
            this.mobBehavior = mobBehavior;
            return this;
        }

        public Builder<T> attackDamage(double attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder<T> addAnimation(String name, ResourceLocation animationLocation) {
            this.animations.put(name, animationLocation);
            return this;
        }

        public Builder<T> addSoundEvent(SoundEventTrigger trigger, Supplier<SoundEvent> soundEventSupplier) {
            this.soundEvents.put(trigger, soundEventSupplier);
            return this;
        }

        public Builder<T> addEquipment(EquipmentSlot slot, ItemStack itemStack) {
            this.equipment.put(slot, itemStack);
            return this;
        }

        public Builder<T> lootTable(ResourceLocation lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public SmallFlyingMobPreset<T> build() {
            return new SmallFlyingMobPreset(this);
        }
    }

    public static enum MobBehavior {
        PASSIVE,
        NEUTRAL,
        AGGRESSIVE;

    }

    public static enum SoundEventTrigger {
        HURT,
        DEATH,
        ATTACK,
        IDLE,
        STEP,
        AMBIENT;

    }
}

