/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.entity.templates;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.mint_gaming_studios.mint_lib.entity.presets.LandAnimalPreset;

public class CustomMobTemplate
extends Animal {
    private final LandAnimalPreset<CustomMobTemplate> preset = new LandAnimalPreset.Builder<CustomMobTemplate>("template_mob", () -> entityType, (eType, lvl) -> new CustomMobTemplate((EntityType<? extends Animal>)eType, (Level)lvl)).build();

    public CustomMobTemplate(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.preset.getEquipment().forEach((arg_0, arg_1) -> ((CustomMobTemplate)this).m_8061_(arg_0, arg_1));
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LandAnimalPreset.createLandAnimalAttributes();
    }

    protected void m_8099_() {
        if (this.preset.getMobBehavior() == LandAnimalPreset.MobBehavior.AGGRESSIVE) {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        } else if (this.preset.getMobBehavior() == LandAnimalPreset.MobBehavior.NEUTRAL) {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    public boolean isAttacking() {
        return false;
    }

    public ResourceLocation getAnimation(String animationName) {
        return this.preset.getAnimations().get(animationName);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return Optional.ofNullable(this.preset.getSoundEvents().get((Object)LandAnimalPreset.SoundEventTrigger.AMBIENT)).map(s -> (SoundEvent)s.get()).orElse(super.m_7515_());
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return Optional.ofNullable(this.preset.getSoundEvents().get((Object)LandAnimalPreset.SoundEventTrigger.HURT)).map(s -> (SoundEvent)s.get()).orElse(super.m_7975_(damageSourceIn));
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return Optional.ofNullable(this.preset.getSoundEvents().get((Object)LandAnimalPreset.SoundEventTrigger.DEATH)).map(s -> (SoundEvent)s.get()).orElse(super.m_5592_());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected ResourceLocation m_7582_() {
        return this.preset.getLootTable() != null ? this.preset.getLootTable() : super.m_7582_();
    }
}

