/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.shroomcraft.client.renderer.entity.state.CluckshroomRenderState;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class CluckshroomBlockStateLayer
extends RenderLayer<CluckshroomRenderState, ChickenModel> {
    private final BlockRenderDispatcher blockRenderer;

    public CluckshroomBlockStateLayer(RenderLayerParent<CluckshroomRenderState, ChickenModel> renderer, BlockRenderDispatcher blockRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, CluckshroomRenderState renderState, float yRot, float xRot) {
        if (!renderState.isBaby) {
            boolean outlineOnly;
            boolean bl = outlineOnly = renderState.appearsGlowing() && renderState.isInvisible;
            if (!renderState.isInvisible || outlineOnly) {
                BlockState blockState = renderState.blockState;
                int packedOverlay = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)renderState, (float)0.0f);
                BlockStateModel blockStateModel = this.blockRenderer.getBlockModel(blockState);
                poseStack.pushPose();
                poseStack.translate(-0.03f, 0.58f, 0.09f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-6.0f));
                poseStack.scale(-0.5f, -0.5f, 0.5f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.submitBlock(poseStack, nodeCollector, packedLight, outlineOnly, renderState.outlineColor, blockState, packedOverlay, blockStateModel);
                poseStack.popPose();
                poseStack.pushPose();
                ((ChickenModel)this.getParentModel()).head.translateAndRotate(poseStack);
                poseStack.translate(0.03f, -0.6f, -0.03f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
                poseStack.scale(-0.5f, -0.5f, 0.5f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.submitBlock(poseStack, nodeCollector, packedLight, outlineOnly, renderState.outlineColor, blockState, packedOverlay, blockStateModel);
                poseStack.popPose();
            }
        }
    }

    private void submitBlock(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, boolean outlineOnly, int outlineColor, BlockState blockState, int packedOverlay, BlockStateModel model) {
        if (outlineOnly) {
            nodeCollector.submitBlockModel(poseStack, RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), model, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay, outlineColor);
        } else {
            nodeCollector.submitBlock(poseStack, blockState, packedLight, packedOverlay, outlineColor);
        }
    }
}

