/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.data.tags;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagProvider;
import fuzs.shroomcraft.init.ModBlockFamilies;
import fuzs.shroomcraft.init.ModItems;
import fuzs.shroomcraft.init.ModTags;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ModItemTagProvider
extends AbstractTagProvider<Item> {
    static final Map<BlockFamily.Variant, TagKey<Item>> VARIANT_TAGS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (Object)ItemTags.BUTTONS).put((Object)BlockFamily.Variant.DOOR, (Object)ItemTags.DOORS).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (Object)ItemTags.FENCES).put((Object)BlockFamily.Variant.FENCE, (Object)ItemTags.FENCES).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (Object)ItemTags.FENCE_GATES).put((Object)BlockFamily.Variant.FENCE_GATE, (Object)ItemTags.FENCE_GATES).put((Object)BlockFamily.Variant.SLAB, (Object)ItemTags.SLABS).put((Object)BlockFamily.Variant.STAIRS, (Object)ItemTags.STAIRS).put((Object)BlockFamily.Variant.TRAPDOOR, (Object)ItemTags.TRAPDOORS).put((Object)BlockFamily.Variant.WALL, (Object)ItemTags.WALLS).build();
    static final Map<BlockFamily.Variant, TagKey<Item>> VARIANT_STONE_TAGS = ImmutableMap.builder().putAll(VARIANT_TAGS).put((Object)BlockFamily.Variant.BUTTON, (Object)ItemTags.STONE_BUTTONS).buildKeepingLast();
    static final Map<BlockFamily.Variant, TagKey<Item>> VARIANT_WOODEN_TAGS = ImmutableMap.builder().putAll(VARIANT_TAGS).put((Object)BlockFamily.Variant.BUTTON, (Object)ItemTags.WOODEN_BUTTONS).put((Object)BlockFamily.Variant.DOOR, (Object)ItemTags.WOODEN_DOORS).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (Object)ItemTags.WOODEN_FENCES).put((Object)BlockFamily.Variant.FENCE, (Object)ItemTags.WOODEN_FENCES).put((Object)BlockFamily.Variant.SLAB, (Object)ItemTags.WOODEN_SLABS).put((Object)BlockFamily.Variant.STAIRS, (Object)ItemTags.WOODEN_STAIRS).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (Object)ItemTags.WOODEN_PRESSURE_PLATES).put((Object)BlockFamily.Variant.TRAPDOOR, (Object)ItemTags.WOODEN_TRAPDOORS).put((Object)BlockFamily.Variant.SIGN, (Object)ItemTags.SIGNS).buildKeepingLast();

    public ModItemTagProvider(DataProviderContext context) {
        super(Registries.ITEM, context);
    }

    public void addTags(HolderLookup.Provider registries) {
        this.tag(ItemTags.PLANKS).add((Object[])new Item[]{(Item)ModItems.SHROOMWOOD_PLANKS.value(), (Item)ModItems.BLUE_SHROOMWOOD_PLANKS.value(), (Item)ModItems.ORANGE_SHROOMWOOD_PLANKS.value(), (Item)ModItems.PURPLE_SHROOMWOOD_PLANKS.value()});
        ModBlockFamilies.getAllFamilyRegistrars().forEach(registrar -> {
            for (Map.Entry<BlockFamily.Variant, TagKey<Item>> entry : VARIANT_WOODEN_TAGS.entrySet()) {
                Holder.Reference<Item> item = registrar.getItem(entry.getKey());
                if (item == null) continue;
                this.tag(entry.getValue()).add(item);
            }
        });
        this.tag(ItemTags.LOGS_THAT_BURN).addTag(new TagKey[]{ModTags.SHROOMWOOD_LOGS_ITEM_TAG, ModTags.BLUE_SHROOMWOOD_LOGS_ITEM_TAG, ModTags.ORANGE_SHROOMWOOD_LOGS_ITEM_TAG, ModTags.PURPLE_SHROOMWOOD_LOGS_ITEM_TAG});
        this.tag(ModTags.SHROOMWOOD_LOGS_ITEM_TAG).add((Object[])new Item[]{(Item)ModItems.STRIPPED_MUSHROOM_STEM.value(), (Item)ModItems.STRIPPED_MUSHROOM_HYPHAE.value()});
        this.tag(ModTags.BLUE_SHROOMWOOD_LOGS_ITEM_TAG).add((Object[])new Item[]{(Item)ModItems.STRIPPED_BLUE_MUSHROOM_STEM.value(), (Item)ModItems.STRIPPED_BLUE_MUSHROOM_HYPHAE.value()});
        this.tag(ModTags.ORANGE_SHROOMWOOD_LOGS_ITEM_TAG).add((Object[])new Item[]{(Item)ModItems.STRIPPED_ORANGE_MUSHROOM_STEM.value(), (Item)ModItems.STRIPPED_ORANGE_MUSHROOM_HYPHAE.value()});
        this.tag(ModTags.PURPLE_SHROOMWOOD_LOGS_ITEM_TAG).add((Object[])new Item[]{(Item)ModItems.STRIPPED_PURPLE_MUSHROOM_STEM.value(), (Item)ModItems.STRIPPED_PURPLE_MUSHROOM_HYPHAE.value()});
        ModBlockFamilies.getAllFamilyRegistrars().forEach(registrar -> {
            if (registrar.hangingSignItem() != null) {
                this.tag(ItemTags.HANGING_SIGNS).add(registrar.hangingSignItem());
            }
            if (registrar.shelfItem() != null) {
                this.tag(ItemTags.WOODEN_SHELVES).add(registrar.shelfItem());
            }
            if (registrar.boatItem() != null) {
                this.tag(ItemTags.BOATS).add(registrar.boatItem());
            }
            if (registrar.chestBoatItem() != null) {
                this.tag(ItemTags.CHEST_BOATS).add(registrar.chestBoatItem());
            }
        });
        this.tag(ItemTags.FISHES).add((Object[])new Item[]{(Item)ModItems.SHROOMFIN.value(), (Item)ModItems.COOKED_SHROOMFIN.value()});
        this.tag(ItemTags.WOLF_FOOD).add((Object[])new Item[]{(Item)ModItems.SHROOMFIN.value(), (Item)ModItems.COOKED_SHROOMFIN.value()});
        this.tag(ModTags.MUSHROOMS_ITEM_TAG).add((Object[])new Item[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM, Items.CRIMSON_FUNGUS, Items.WARPED_FUNGUS}).add((Object[])new Item[]{(Item)ModItems.BLUE_MUSHROOM.value(), (Item)ModItems.ORANGE_MUSHROOM.value(), (Item)ModItems.PURPLE_MUSHROOM.value()});
        this.tag("c:buckets/entity_water").add((Object)((Item)ModItems.SHROOMFIN_BUCKET.value()));
    }
}

