/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.init;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.PushReaction;

public class BlockFamilyRegistrar {
    static final Map<BlockFamily.Variant, BiFunction<BlockFamily.Builder, Block, BlockFamily.Builder>> VARIANT_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.STAIRS, BlockFamily.Builder::stairs).put((Object)BlockFamily.Variant.SLAB, BlockFamily.Builder::slab).put((Object)BlockFamily.Variant.WALL, BlockFamily.Builder::wall).put((Object)BlockFamily.Variant.FENCE, BlockFamily.Builder::fence).put((Object)BlockFamily.Variant.CUSTOM_FENCE, BlockFamily.Builder::customFence).put((Object)BlockFamily.Variant.FENCE_GATE, BlockFamily.Builder::fenceGate).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, BlockFamily.Builder::customFenceGate).put((Object)BlockFamily.Variant.DOOR, BlockFamily.Builder::door).put((Object)BlockFamily.Variant.TRAPDOOR, BlockFamily.Builder::trapdoor).put((Object)BlockFamily.Variant.BUTTON, BlockFamily.Builder::button).put((Object)BlockFamily.Variant.PRESSURE_PLATE, BlockFamily.Builder::pressurePlate).build();
    static final Set<BlockFamily.Variant> FLAMMABLE_VARIANTS = ImmutableSet.of((Object)BlockFamily.Variant.CUSTOM_FENCE, (Object)BlockFamily.Variant.FENCE, (Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (Object)BlockFamily.Variant.FENCE_GATE, (Object)BlockFamily.Variant.STAIRS, (Object)BlockFamily.Variant.SLAB, (Object[])new BlockFamily.Variant[0]);
    final Map<BlockFamily.Variant, Holder.Reference<Block>> blockVariants = new LinkedHashMap<BlockFamily.Variant, Holder.Reference<Block>>();
    final Map<BlockFamily.Variant, Holder.Reference<Item>> itemVariants = new LinkedHashMap<BlockFamily.Variant, Holder.Reference<Item>>();
    final Holder.Reference<Block> baseBlock;
    final BlockSetType blockSetType;
    final WoodType woodType;
    Holder.Reference<Block> hangingSignBlock;
    Holder.Reference<Block> wallHangingSignBlock;
    Holder.Reference<Item> hangingSignItem;
    Holder.Reference<Block> shelfBlock;
    Holder.Reference<Item> shelfItem;
    Holder.Reference<Item> boatItem;
    Holder.Reference<Item> chestBoatItem;
    Holder.Reference<EntityType<Boat>> boatEntityType;
    Holder.Reference<EntityType<ChestBoat>> chestBoatEntityType;

    BlockFamilyRegistrar(Holder.Reference<Block> baseBlock, BlockSetType blockSetType, WoodType woodType) {
        this.baseBlock = baseBlock;
        this.blockSetType = blockSetType;
        this.woodType = woodType;
    }

    public static Builder builder(RegistryManager registries, Holder.Reference<Block> baseBlock, String basePath) {
        BlockSetType blockSetType = new BlockSetType(registries.makeKey(basePath).toString());
        WoodType woodType = new WoodType(registries.makeKey(basePath).toString(), blockSetType);
        return new Builder(registries, new BlockFamilyRegistrar(baseBlock, blockSetType, woodType), basePath);
    }

    public static Builder any(RegistryManager registries, Holder.Reference<Block> baseBlock, String basePath) {
        return BlockFamilyRegistrar.builder(registries, baseBlock, basePath).stairs().slab().wall();
    }

    public static Builder metal(RegistryManager registries, Holder.Reference<Block> baseBlock, String basePath) {
        Builder builder = BlockFamilyRegistrar.builder(registries, baseBlock, basePath);
        return builder.stairs().slab().door(builder.familyRegistrar.blockSetType).trapdoor(builder.familyRegistrar.blockSetType).pressurePlate(builder.familyRegistrar.blockSetType);
    }

    public static Builder wooden(RegistryManager registries, Holder.Reference<Block> baseBlock, String basePath) {
        Builder builder = BlockFamilyRegistrar.builder(registries, baseBlock, basePath);
        return builder.stairs().slab().fence().fenceGate(builder.familyRegistrar.woodType).door(builder.familyRegistrar.blockSetType).trapdoor(builder.familyRegistrar.blockSetType).pressurePlate(builder.familyRegistrar.blockSetType).button(builder.familyRegistrar.blockSetType).sign(builder.familyRegistrar.woodType).hangingSign(builder.familyRegistrar.woodType).shelf().boat();
    }

    public Map<BlockFamily.Variant, Holder.Reference<Block>> getBlockVariants() {
        return this.blockVariants;
    }

    public void forEachBlockVariant(Consumer<Holder.Reference<Block>> consumer) {
        this.blockVariants.values().forEach(consumer);
        consumer.accept(this.hangingSignBlock);
        consumer.accept(this.wallHangingSignBlock);
        consumer.accept(this.shelfBlock);
    }

    public void forEachFlammableVariant(Consumer<Holder.Reference<Block>> consumer) {
        this.blockVariants.forEach((variant, holder) -> {
            if (FLAMMABLE_VARIANTS.contains(variant)) {
                consumer.accept((Holder.Reference<Block>)holder);
            }
        });
    }

    public Map<BlockFamily.Variant, Holder.Reference<Item>> getItemVariants() {
        return this.itemVariants;
    }

    public void forEachItemVariant(Consumer<Holder.Reference<Item>> consumer) {
        this.itemVariants.values().forEach(consumer);
        consumer.accept(this.hangingSignItem);
        consumer.accept(this.shelfItem);
        consumer.accept(this.boatItem);
        consumer.accept(this.chestBoatItem);
    }

    public void forEachEntityType(Consumer<Holder.Reference<? extends EntityType<?>>> consumer) {
        consumer.accept(this.boatEntityType);
        consumer.accept(this.chestBoatEntityType);
    }

    public Holder.Reference<Block> getBlock(BlockFamily.Variant variant) {
        return this.blockVariants.get(variant);
    }

    public Holder.Reference<Item> getItem(BlockFamily.Variant variant) {
        return this.itemVariants.get(variant);
    }

    public Holder.Reference<Block> getBaseBlock() {
        return this.baseBlock;
    }

    public BlockSetType getBlockSetType() {
        return this.blockSetType;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public Holder.Reference<Block> hangingSignBlock() {
        return this.hangingSignBlock;
    }

    public Holder.Reference<Block> wallHangingSignBlock() {
        return this.wallHangingSignBlock;
    }

    public Holder.Reference<Item> hangingSignItem() {
        return this.hangingSignItem;
    }

    public Holder.Reference<Block> shelfBlock() {
        return this.shelfBlock;
    }

    public Holder.Reference<Item> shelfItem() {
        return this.shelfItem;
    }

    public Holder.Reference<Item> boatItem() {
        return this.boatItem;
    }

    public Holder.Reference<Item> chestBoatItem() {
        return this.chestBoatItem;
    }

    public Holder.Reference<EntityType<Boat>> boatEntityType() {
        return this.boatEntityType;
    }

    public Holder.Reference<EntityType<ChestBoat>> chestBoatEntityType() {
        return this.chestBoatEntityType;
    }

    public BlockFamily.Builder getFamily() {
        BlockFamily.Builder builder = new BlockFamily.Builder((Block)this.baseBlock.value());
        VARIANT_BUILDERS.forEach((variant, function) -> {
            if (this.blockVariants.containsKey(variant)) {
                function.apply(builder, (Block)this.blockVariants.get(variant).value());
            }
        });
        if (this.blockVariants.containsKey(BlockFamily.Variant.SIGN) && this.blockVariants.containsKey(BlockFamily.Variant.WALL_SIGN)) {
            builder.sign((Block)this.blockVariants.get(BlockFamily.Variant.SIGN).value(), (Block)this.blockVariants.get(BlockFamily.Variant.WALL_SIGN).value());
        }
        return builder;
    }

    public BlockFamily getWoodenFamily() {
        return this.getFamily().recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    }

    public static class Builder {
        final RegistryManager registries;
        final BlockFamilyRegistrar familyRegistrar;
        final String basePath;

        public Builder(RegistryManager registries, BlockFamilyRegistrar familyRegistrar, String basePath) {
            this.registries = registries;
            this.familyRegistrar = familyRegistrar;
            this.basePath = basePath;
        }

        public BlockFamilyRegistrar getFamily() {
            return this.familyRegistrar;
        }

        private Block baseBlock() {
            return (Block)this.familyRegistrar.baseBlock.value();
        }

        private String basePath() {
            return this.basePath;
        }

        public Builder stairs() {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.STAIRS, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_stairs", properties -> new StairBlock(this.baseBlock().defaultBlockState(), properties), () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)this.baseBlock())));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.STAIRS, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.STAIRS)));
            return this;
        }

        public Builder slab() {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.SLAB, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_slab", SlabBlock::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock())));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.SLAB, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.SLAB)));
            return this;
        }

        public Builder wall() {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.WALL, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_wall", WallBlock::new, () -> BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)this.baseBlock()).forceSolidOn()));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.WALL, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.WALL)));
            return this;
        }

        public Builder fence() {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.FENCE, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_fence", FenceBlock::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock())));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.FENCE, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.FENCE)));
            return this;
        }

        public Builder fenceGate(WoodType woodType) {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.FENCE_GATE, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_fence_gate", properties -> new FenceGateBlock(woodType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).forceSolidOn()));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.FENCE_GATE, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.FENCE_GATE)));
            return this;
        }

        public Builder door(BlockSetType blockSetType) {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.DOOR, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_door", properties -> new DoorBlock(blockSetType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).noOcclusion().pushReaction(PushReaction.DESTROY)));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.DOOR, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.DOOR), DoubleHighBlockItem::new));
            return this;
        }

        public Builder trapdoor(BlockSetType blockSetType) {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.TRAPDOOR, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_trapdoor", properties -> new TrapDoorBlock(blockSetType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).noOcclusion().isValidSpawn(Blocks::never)));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.TRAPDOOR, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.TRAPDOOR)));
            return this;
        }

        public Builder pressurePlate(BlockSetType blockSetType) {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.PRESSURE_PLATE, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_pressure_plate", properties -> new PressurePlateBlock(blockSetType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).forceSolidOn().noCollision().pushReaction(PushReaction.DESTROY)));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.PRESSURE_PLATE, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.PRESSURE_PLATE)));
            return this;
        }

        public Builder button(BlockSetType blockSetType) {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.BUTTON, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_button", properties -> new ButtonBlock(blockSetType, 30, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).noCollision().pushReaction(PushReaction.DESTROY)));
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.BUTTON, (Holder.Reference<Item>)this.registries.registerBlockItem((Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.BUTTON)));
            return this;
        }

        public Builder sign(WoodType woodType) {
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.SIGN, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_sign", properties -> new StandingSignBlock(woodType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).forceSolidOn().noCollision()));
            Holder signHolder = (Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.SIGN);
            this.familyRegistrar.blockVariants.put(BlockFamily.Variant.WALL_SIGN, (Holder.Reference<Block>)this.registries.registerBlock(this.basePath() + "_wall_sign", properties -> new WallSignBlock(woodType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).overrideLootTable(((Block)signHolder.value()).getLootTable()).overrideDescription(((Block)signHolder.value()).getDescriptionId()).forceSolidOn().noCollision()));
            Holder wallSignHolder = (Holder)this.familyRegistrar.blockVariants.get(BlockFamily.Variant.WALL_SIGN);
            this.familyRegistrar.itemVariants.put(BlockFamily.Variant.SIGN, (Holder.Reference<Item>)this.registries.registerBlockItem(signHolder, (block, properties) -> new SignItem(block, (Block)wallSignHolder.value(), properties), () -> new Item.Properties().stacksTo(16)));
            return this;
        }

        public Builder hangingSign(WoodType woodType) {
            this.familyRegistrar.hangingSignBlock = this.registries.registerBlock(this.basePath() + "_hanging_sign", properties -> new CeilingHangingSignBlock(woodType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).forceSolidOn().noCollision());
            Holder.Reference<Block> hangingSignHolder = this.familyRegistrar.hangingSignBlock;
            this.familyRegistrar.wallHangingSignBlock = this.registries.registerBlock(this.basePath() + "_wall_hanging_sign", properties -> new WallHangingSignBlock(woodType, properties), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).overrideLootTable(((Block)hangingSignHolder.value()).getLootTable()).overrideDescription(((Block)hangingSignHolder.value()).getDescriptionId()).forceSolidOn().noCollision());
            Holder.Reference<Block> wallHangingSignHolder = this.familyRegistrar.wallHangingSignBlock;
            this.familyRegistrar.hangingSignItem = this.registries.registerBlockItem(hangingSignHolder, (block, properties) -> new HangingSignItem(block, (Block)wallHangingSignHolder.value(), properties), () -> new Item.Properties().stacksTo(16));
            return this;
        }

        public Builder shelf() {
            this.familyRegistrar.shelfBlock = this.registries.registerBlock(this.basePath() + "_shelf", ShelfBlock::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.baseBlock()).sound(SoundType.SHELF));
            this.familyRegistrar.shelfItem = this.registries.registerBlockItem(this.familyRegistrar.shelfBlock, () -> new Item.Properties().component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
            return this;
        }

        public Builder boat() {
            this.familyRegistrar.boatEntityType = this.registries.registerEntityType(this.basePath() + "_boat", () -> EntityType.Builder.of((entityType, level) -> new Boat(entityType, level, () -> (Item)this.familyRegistrar.boatItem.value()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
            this.familyRegistrar.chestBoatEntityType = this.registries.registerEntityType(this.basePath() + "_chest_boat", () -> EntityType.Builder.of((entityType, level) -> new ChestBoat(entityType, level, () -> (Item)this.familyRegistrar.chestBoatItem.value()), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
            this.familyRegistrar.boatItem = this.registries.registerItem(this.basePath() + "_boat", properties -> new BoatItem((EntityType)this.familyRegistrar.boatEntityType.value(), properties), () -> new Item.Properties().stacksTo(1));
            this.familyRegistrar.chestBoatItem = this.registries.registerItem(this.basePath() + "_chest_boat", properties -> new BoatItem((EntityType)this.familyRegistrar.chestBoatEntityType.value(), properties), () -> new Item.Properties().stacksTo(1));
            return this;
        }
    }
}

