/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.init;

import com.google.common.collect.ImmutableList;
import fuzs.shroomcraft.init.ModConfiguredFeatures;
import fuzs.shroomcraft.init.ModRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.jetbrains.annotations.Nullable;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> MUSHROOM_ISLAND_VEGETATION_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "mushroom_island_vegetation");
    public static final ResourceKey<PlacedFeature> BLUE_MUSHROOM_NORMAL_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "blue_mushroom_normal");
    public static final ResourceKey<PlacedFeature> ORANGE_MUSHROOM_NORMAL_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "orange_mushroom_normal");
    public static final ResourceKey<PlacedFeature> PURPLE_MUSHROOM_NORMAL_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "purple_mushroom_normal");
    public static final ResourceKey<PlacedFeature> BLUE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "blue_mushroom_mushroom_fields");
    public static final ResourceKey<PlacedFeature> ORANGE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "orange_mushroom_mushroom_fields");
    public static final ResourceKey<PlacedFeature> PURPLE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "purple_mushroom_mushroom_fields");
    public static final ResourceKey<PlacedFeature> MYCELIAL_GROWTH_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "mycelial_growth");
    public static final ResourceKey<PlacedFeature> PATCH_MUSHROOM_SPROUTS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "patch_mushroom_sprouts");
    public static final ResourceKey<PlacedFeature> PATCH_BLUE_MUSHROOM_SPROUTS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "patch_blue_mushroom_sprouts");
    public static final ResourceKey<PlacedFeature> PATCH_ORANGE_MUSHROOM_SPROUTS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "patch_orange_mushroom_sprouts");
    public static final ResourceKey<PlacedFeature> PATCH_PURPLE_MUSHROOM_SPROUTS_PLACED_FEATURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.PLACED_FEATURE, "patch_purple_mushroom_sprouts");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureLookup = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, MUSHROOM_ISLAND_VEGETATION_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.MUSHROOM_ISLAND_VEGETATION_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, BLUE_MUSHROOM_NORMAL_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_BLUE_MUSHROOM_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(384, null));
        PlacementUtils.register(context, ORANGE_MUSHROOM_NORMAL_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_ORANGE_MUSHROOM_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(384, null));
        PlacementUtils.register(context, PURPLE_MUSHROOM_NORMAL_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_PURPLE_MUSHROOM_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(384, null));
        PlacementUtils.register(context, BLUE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_BLUE_MUSHROOM_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(64, null));
        PlacementUtils.register(context, ORANGE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_ORANGE_MUSHROOM_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(64, null));
        PlacementUtils.register(context, PURPLE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_PURPLE_MUSHROOM_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(64, null));
        PlacementUtils.register(context, MYCELIAL_GROWTH_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.MYCELIAL_GROWTH_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)204, (int)250)), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, InSquarePlacement.spread(), BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(16, null));
        PlacementUtils.register(context, PATCH_BLUE_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_BLUE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(16, null));
        PlacementUtils.register(context, PATCH_ORANGE_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_ORANGE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(16, null));
        PlacementUtils.register(context, PATCH_PURPLE_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModConfiguredFeatures.PATCH_PURPLE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModPlacedFeatures.getMushroomPlacement(16, null));
    }

    private static List<PlacementModifier> getMushroomPlacement(int rarity, @Nullable PlacementModifier placement) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (placement != null) {
            builder.add((Object)placement);
        }
        if (rarity != 0) {
            builder.add((Object)RarityFilter.onAverageOnceEvery((int)rarity));
        }
        builder.add((Object)InSquarePlacement.spread());
        builder.add((Object)PlacementUtils.HEIGHTMAP);
        builder.add((Object)BiomeFilter.biome());
        return builder.build();
    }
}

