/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.init;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_11586;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1690;
import net.minecraft.class_1749;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2440;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2551;
import net.minecraft.class_3619;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5794;
import net.minecraft.class_6880;
import net.minecraft.class_7264;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8177;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class BlockFamilyRegistrar {
    static final Map<class_5794.class_5796, BiFunction<class_5794.class_5795, class_2248, class_5794.class_5795>> VARIANT_BUILDERS = ImmutableMap.builder().put((Object)class_5794.class_5796.field_28540, class_5794.class_5795::method_33493).put((Object)class_5794.class_5796.field_28539, class_5794.class_5795::method_33492).put((Object)class_5794.class_5796.field_28544, class_5794.class_5795::method_33497).put((Object)class_5794.class_5796.field_28536, class_5794.class_5795::method_33490).put((Object)class_5794.class_5796.field_40592, class_5794.class_5795::method_45966).put((Object)class_5794.class_5796.field_28537, class_5794.class_5795::method_33491).put((Object)class_5794.class_5796.field_40593, class_5794.class_5795::method_45967).put((Object)class_5794.class_5796.field_28535, class_5794.class_5795::method_33489).put((Object)class_5794.class_5796.field_28543, class_5794.class_5795::method_33496).put((Object)class_5794.class_5796.field_28533, class_5794.class_5795::method_33482).put((Object)class_5794.class_5796.field_28541, class_5794.class_5795::method_33494).build();
    static final Set<class_5794.class_5796> FLAMMABLE_VARIANTS = ImmutableSet.of((Object)class_5794.class_5796.field_40592, (Object)class_5794.class_5796.field_28536, (Object)class_5794.class_5796.field_40593, (Object)class_5794.class_5796.field_28537, (Object)class_5794.class_5796.field_28540, (Object)class_5794.class_5796.field_28539, (Object[])new class_5794.class_5796[0]);
    final Map<class_5794.class_5796, class_6880.class_6883<class_2248>> blockVariants = new LinkedHashMap<class_5794.class_5796, class_6880.class_6883<class_2248>>();
    final Map<class_5794.class_5796, class_6880.class_6883<class_1792>> itemVariants = new LinkedHashMap<class_5794.class_5796, class_6880.class_6883<class_1792>>();
    final class_6880.class_6883<class_2248> baseBlock;
    final class_8177 blockSetType;
    final class_4719 woodType;
    class_6880.class_6883<class_2248> hangingSignBlock;
    class_6880.class_6883<class_2248> wallHangingSignBlock;
    class_6880.class_6883<class_1792> hangingSignItem;
    class_6880.class_6883<class_2248> shelfBlock;
    class_6880.class_6883<class_1792> shelfItem;
    class_6880.class_6883<class_1792> boatItem;
    class_6880.class_6883<class_1792> chestBoatItem;
    class_6880.class_6883<class_1299<class_1690>> boatEntityType;
    class_6880.class_6883<class_1299<class_7264>> chestBoatEntityType;

    BlockFamilyRegistrar(class_6880.class_6883<class_2248> baseBlock, class_8177 blockSetType, class_4719 woodType) {
        this.baseBlock = baseBlock;
        this.blockSetType = blockSetType;
        this.woodType = woodType;
    }

    public static Builder builder(RegistryManager registries, class_6880.class_6883<class_2248> baseBlock, String basePath) {
        class_8177 blockSetType = new class_8177(registries.makeKey(basePath).toString());
        class_4719 woodType = new class_4719(registries.makeKey(basePath).toString(), blockSetType);
        return new Builder(registries, new BlockFamilyRegistrar(baseBlock, blockSetType, woodType), basePath);
    }

    public static Builder any(RegistryManager registries, class_6880.class_6883<class_2248> baseBlock, String basePath) {
        return BlockFamilyRegistrar.builder(registries, baseBlock, basePath).stairs().slab().wall();
    }

    public static Builder metal(RegistryManager registries, class_6880.class_6883<class_2248> baseBlock, String basePath) {
        Builder builder = BlockFamilyRegistrar.builder(registries, baseBlock, basePath);
        return builder.stairs().slab().door(builder.familyRegistrar.blockSetType).trapdoor(builder.familyRegistrar.blockSetType).pressurePlate(builder.familyRegistrar.blockSetType);
    }

    public static Builder wooden(RegistryManager registries, class_6880.class_6883<class_2248> baseBlock, String basePath) {
        Builder builder = BlockFamilyRegistrar.builder(registries, baseBlock, basePath);
        return builder.stairs().slab().fence().fenceGate(builder.familyRegistrar.woodType).door(builder.familyRegistrar.blockSetType).trapdoor(builder.familyRegistrar.blockSetType).pressurePlate(builder.familyRegistrar.blockSetType).button(builder.familyRegistrar.blockSetType).sign(builder.familyRegistrar.woodType).hangingSign(builder.familyRegistrar.woodType).shelf().boat();
    }

    public Map<class_5794.class_5796, class_6880.class_6883<class_2248>> getBlockVariants() {
        return this.blockVariants;
    }

    public void forEachBlockVariant(Consumer<class_6880.class_6883<class_2248>> consumer) {
        this.blockVariants.values().forEach(consumer);
        consumer.accept(this.hangingSignBlock);
        consumer.accept(this.wallHangingSignBlock);
        consumer.accept(this.shelfBlock);
    }

    public void forEachFlammableVariant(Consumer<class_6880.class_6883<class_2248>> consumer) {
        this.blockVariants.forEach((variant, holder) -> {
            if (FLAMMABLE_VARIANTS.contains(variant)) {
                consumer.accept((class_6880.class_6883<class_2248>)holder);
            }
        });
    }

    public Map<class_5794.class_5796, class_6880.class_6883<class_1792>> getItemVariants() {
        return this.itemVariants;
    }

    public void forEachItemVariant(Consumer<class_6880.class_6883<class_1792>> consumer) {
        this.itemVariants.values().forEach(consumer);
        consumer.accept(this.hangingSignItem);
        consumer.accept(this.shelfItem);
        consumer.accept(this.boatItem);
        consumer.accept(this.chestBoatItem);
    }

    public void forEachEntityType(Consumer<class_6880.class_6883<? extends class_1299<?>>> consumer) {
        consumer.accept(this.boatEntityType);
        consumer.accept(this.chestBoatEntityType);
    }

    public class_6880.class_6883<class_2248> getBlock(class_5794.class_5796 variant) {
        return this.blockVariants.get(variant);
    }

    public class_6880.class_6883<class_1792> getItem(class_5794.class_5796 variant) {
        return this.itemVariants.get(variant);
    }

    public class_6880.class_6883<class_2248> getBaseBlock() {
        return this.baseBlock;
    }

    public class_8177 getBlockSetType() {
        return this.blockSetType;
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    public class_6880.class_6883<class_2248> hangingSignBlock() {
        return this.hangingSignBlock;
    }

    public class_6880.class_6883<class_2248> wallHangingSignBlock() {
        return this.wallHangingSignBlock;
    }

    public class_6880.class_6883<class_1792> hangingSignItem() {
        return this.hangingSignItem;
    }

    public class_6880.class_6883<class_2248> shelfBlock() {
        return this.shelfBlock;
    }

    public class_6880.class_6883<class_1792> shelfItem() {
        return this.shelfItem;
    }

    public class_6880.class_6883<class_1792> boatItem() {
        return this.boatItem;
    }

    public class_6880.class_6883<class_1792> chestBoatItem() {
        return this.chestBoatItem;
    }

    public class_6880.class_6883<class_1299<class_1690>> boatEntityType() {
        return this.boatEntityType;
    }

    public class_6880.class_6883<class_1299<class_7264>> chestBoatEntityType() {
        return this.chestBoatEntityType;
    }

    public class_5794.class_5795 getFamily() {
        class_5794.class_5795 builder = new class_5794.class_5795((class_2248)this.baseBlock.comp_349());
        VARIANT_BUILDERS.forEach((variant, function) -> {
            if (this.blockVariants.containsKey(variant)) {
                function.apply(builder, (class_2248)this.blockVariants.get(variant).comp_349());
            }
        });
        if (this.blockVariants.containsKey(class_5794.class_5796.field_28538) && this.blockVariants.containsKey(class_5794.class_5796.field_28545)) {
            builder.method_33483((class_2248)this.blockVariants.get(class_5794.class_5796.field_28538).comp_349(), (class_2248)this.blockVariants.get(class_5794.class_5796.field_28545).comp_349());
        }
        return builder;
    }

    public class_5794 getWoodenFamily() {
        return this.getFamily().method_33484("wooden").method_33487("has_planks").method_33481();
    }

    public static class Builder {
        final RegistryManager registries;
        final BlockFamilyRegistrar familyRegistrar;
        final String basePath;

        public Builder(RegistryManager registries, BlockFamilyRegistrar familyRegistrar, String basePath) {
            this.registries = registries;
            this.familyRegistrar = familyRegistrar;
            this.basePath = basePath;
        }

        public BlockFamilyRegistrar getFamily() {
            return this.familyRegistrar;
        }

        private class_2248 baseBlock() {
            return (class_2248)this.familyRegistrar.baseBlock.comp_349();
        }

        private String basePath() {
            return this.basePath;
        }

        public Builder stairs() {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28540, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_stairs", properties -> new class_2510(this.baseBlock().method_9564(), properties), () -> class_4970.class_2251.method_55226((class_4970)this.baseBlock())));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28540, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28540)));
            return this;
        }

        public Builder slab() {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28539, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_slab", class_2482::new, () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock())));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28539, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28539)));
            return this;
        }

        public Builder wall() {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28544, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_wall", class_2544::new, () -> class_4970.class_2251.method_55226((class_4970)this.baseBlock()).method_51369()));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28544, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28544)));
            return this;
        }

        public Builder fence() {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28536, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_fence", class_2354::new, () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock())));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28536, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28536)));
            return this;
        }

        public Builder fenceGate(class_4719 woodType) {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28537, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_fence_gate", properties -> new class_2349(woodType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_51369()));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28537, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28537)));
            return this;
        }

        public Builder door(class_8177 blockSetType) {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28535, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_door", properties -> new class_2323(blockSetType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_22488().method_50012(class_3619.field_15971)));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28535, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28535), class_1765::new));
            return this;
        }

        public Builder trapdoor(class_8177 blockSetType) {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28543, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_trapdoor", properties -> new class_2533(blockSetType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_22488().method_26235(class_2246::method_26114)));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28543, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28543)));
            return this;
        }

        public Builder pressurePlate(class_8177 blockSetType) {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28541, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_pressure_plate", properties -> new class_2440(blockSetType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_51369().method_9634().method_50012(class_3619.field_15971)));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28541, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28541)));
            return this;
        }

        public Builder button(class_8177 blockSetType) {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28533, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_button", properties -> new class_2269(blockSetType, 30, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_9634().method_50012(class_3619.field_15971)));
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28533, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem((class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28533)));
            return this;
        }

        public Builder sign(class_4719 woodType) {
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28538, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_sign", properties -> new class_2508(woodType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_51369().method_9634()));
            class_6880 signHolder = (class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28538);
            this.familyRegistrar.blockVariants.put(class_5794.class_5796.field_28545, (class_6880.class_6883<class_2248>)this.registries.registerBlock(this.basePath() + "_wall_sign", properties -> new class_2551(woodType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_63502(((class_2248)signHolder.comp_349()).method_26162()).method_63501(((class_2248)signHolder.comp_349()).method_63499()).method_51369().method_9634()));
            class_6880 wallSignHolder = (class_6880)this.familyRegistrar.blockVariants.get(class_5794.class_5796.field_28545);
            this.familyRegistrar.itemVariants.put(class_5794.class_5796.field_28538, (class_6880.class_6883<class_1792>)this.registries.registerBlockItem(signHolder, (block, properties) -> new class_1822(block, (class_2248)wallSignHolder.comp_349(), properties), () -> new class_1792.class_1793().method_7889(16)));
            return this;
        }

        public Builder hangingSign(class_4719 woodType) {
            this.familyRegistrar.hangingSignBlock = this.registries.registerBlock(this.basePath() + "_hanging_sign", properties -> new class_7713(woodType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_51369().method_9634());
            class_6880.class_6883<class_2248> hangingSignHolder = this.familyRegistrar.hangingSignBlock;
            this.familyRegistrar.wallHangingSignBlock = this.registries.registerBlock(this.basePath() + "_wall_hanging_sign", properties -> new class_7715(woodType, properties), () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_63502(((class_2248)hangingSignHolder.comp_349()).method_26162()).method_63501(((class_2248)hangingSignHolder.comp_349()).method_63499()).method_51369().method_9634());
            class_6880.class_6883<class_2248> wallHangingSignHolder = this.familyRegistrar.wallHangingSignBlock;
            this.familyRegistrar.hangingSignItem = this.registries.registerBlockItem(hangingSignHolder, (block, properties) -> new class_7707(block, (class_2248)wallHangingSignHolder.comp_349(), properties), () -> new class_1792.class_1793().method_7889(16));
            return this;
        }

        public Builder shelf() {
            this.familyRegistrar.shelfBlock = this.registries.registerBlock(this.basePath() + "_shelf", class_11586::new, () -> class_4970.class_2251.method_9630((class_4970)this.baseBlock()).method_9626(class_2498.field_61430));
            this.familyRegistrar.shelfItem = this.registries.registerBlockItem(this.familyRegistrar.shelfBlock, () -> new class_1792.class_1793().method_57349(class_9334.field_49622, (Object)class_9288.field_49334));
            return this;
        }

        public Builder boat() {
            this.familyRegistrar.boatEntityType = this.registries.registerEntityType(this.basePath() + "_boat", () -> class_1299.class_1300.method_5903((entityType, level) -> new class_1690(entityType, level, () -> (class_1792)this.familyRegistrar.boatItem.comp_349()), (class_1311)class_1311.field_17715).method_63006().method_17687(1.375f, 0.5625f).method_55687(0.5625f).method_27299(10));
            this.familyRegistrar.chestBoatEntityType = this.registries.registerEntityType(this.basePath() + "_chest_boat", () -> class_1299.class_1300.method_5903((entityType, level) -> new class_7264(entityType, level, () -> (class_1792)this.familyRegistrar.chestBoatItem.comp_349()), (class_1311)class_1311.field_17715).method_63006().method_17687(1.375f, 0.5625f).method_55687(0.5625f).method_27299(10));
            this.familyRegistrar.boatItem = this.registries.registerItem(this.basePath() + "_boat", properties -> new class_1749((class_1299)this.familyRegistrar.boatEntityType.comp_349(), properties), () -> new class_1792.class_1793().method_7889(1));
            this.familyRegistrar.chestBoatItem = this.registries.registerItem(this.basePath() + "_chest_boat", properties -> new class_1749((class_1299)this.familyRegistrar.chestBoatEntityType.comp_349(), properties), () -> new class_1792.class_1793().method_7889(1));
            return this;
        }
    }
}

