/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeOrangeMushroomFeature
extends AbstractHugeMushroomFeature {
    public HugeOrangeMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    protected void makeCap(LevelAccessor level, RandomSource random, BlockPos pos, int treeHeight, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfiguration config) {
        for (int i = treeHeight - 1; i <= treeHeight; ++i) {
            int j = config.foliageRadius - 1;
            int k = config.foliageRadius - 3;
            for (int l = -j; l <= j; ++l) {
                for (int m = -j; m <= j; ++m) {
                    boolean bl6;
                    boolean bl = l == -j;
                    boolean bl2 = l == j;
                    boolean bl3 = m == -j;
                    boolean bl4 = m == j;
                    boolean bl5 = bl || bl2;
                    boolean bl7 = bl6 = bl3 || bl4;
                    if ((i < treeHeight || bl5 && bl6) && bl5 == bl6 && (i != treeHeight - 1 || !bl5 || !bl6)) continue;
                    int offsetX = l + (i == treeHeight - 1 && Math.abs(l) > Math.abs(m) ? Mth.sign((double)l) : 0);
                    int offsetZ = m + (i == treeHeight - 1 && Math.abs(m) > Math.abs(l) ? Mth.sign((double)m) : 0);
                    mutablePos.setWithOffset((Vec3i)pos, offsetX, i, offsetZ);
                    if (level.getBlockState((BlockPos)mutablePos).isSolidRender()) continue;
                    BlockState blockState = config.capProvider.getState(random, pos);
                    if (blockState.hasProperty((Property)HugeMushroomBlock.WEST) && blockState.hasProperty((Property)HugeMushroomBlock.EAST) && blockState.hasProperty((Property)HugeMushroomBlock.NORTH) && blockState.hasProperty((Property)HugeMushroomBlock.SOUTH) && blockState.hasProperty((Property)HugeMushroomBlock.UP)) {
                        blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(i >= treeHeight - 1))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(l < -k))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(l > k))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(m < -k))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(m > k));
                    }
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, blockState);
                }
            }
        }
    }

    protected int getTreeRadiusForHeight(int unused, int height, int foliageRadius, int y) {
        int i = 0;
        if (y < height && y >= height - 3) {
            i = foliageRadius;
        } else if (y == height) {
            i = foliageRadius;
        }
        return i;
    }
}

