/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.entity.animal;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.shroomcraft.Shroomcraft;
import fuzs.shroomcraft.init.ModBlocks;
import fuzs.shroomcraft.init.ModLootTables;
import fuzs.shroomcraft.init.ModRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_10179;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1438;
import net.minecraft.class_1538;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class ModMushroomCow
extends class_1438 {
    private static final class_2940<ColorVariant> DATA_VARIANT_ID = class_2945.method_12791(ModMushroomCow.class, (class_2941)((class_2941)ModRegistry.MUSHROOM_VARIANT_ENTITY_DATA_SERIALIZER.comp_349()));
    private static final Set<class_3730> VALID_SPAWN_REASONS = Set.of(class_3730.field_16469, class_3730.field_47245, class_3730.field_16465, class_3730.field_16470);
    @Nullable
    private UUID lastLightningBoltUUID;

    public ModMushroomCow(class_1299<? extends class_1438> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static boolean checkMooshroomSpawnRules(class_1299<? extends class_1438> entityType, class_1936 level, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return ModMushroomCow.method_20665(entityType, (class_1936)level, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) || level.method_8320(pos.method_10074()).method_26164(class_3481.field_21953);
    }

    public static EventResult onEntityLoad(class_1297 entity, class_3218 serverLevel, boolean isNewlySpawned) {
        @Nullable class_3730 entitySpawnReason = EntityHelper.getMobSpawnReason((class_1297)entity);
        if (isNewlySpawned && entitySpawnReason != null && entity.method_5864() == class_1299.field_6143 && VALID_SPAWN_REASONS.contains(entitySpawnReason) && ModMushroomCow.getSpawnAsCustomEntityOdds(serverLevel, entity.method_24515(), serverLevel.method_8409())) {
            class_1438 mushroomCow = (class_1438)entity;
            mushroomCow.method_29243((class_1299)ModRegistry.MOOSHROOM_ENTITY_TYPE.comp_349(), class_10179.method_63607((class_1308)mushroomCow, (boolean)true, (boolean)true), mob -> {
                @Nullable class_1266 difficulty = new class_1266(serverLevel.method_8407(), serverLevel.method_8532(), 0L, serverLevel.method_30272());
                mob.method_5943((class_5425)serverLevel, difficulty, entitySpawnReason, null);
            });
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static boolean getSpawnAsCustomEntityOdds(class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (serverLevel.method_23753(blockPos).method_40220(class_6908.field_36518)) {
            return true;
        }
        return randomSource.method_43048(ColorVariant.getOverworldVariants().length + 1) != 0;
    }

    public static EventResultHolder<class_1269> onEntityInteract(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 entity) {
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (itemInHand.method_31574(class_1802.field_8299) && entity.method_5805() && entity.method_5864() == ModRegistry.MOOSHROOM_ENTITY_TYPE.comp_349()) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                Optional<class_1308> optional = ModMushroomCow.spawnOffspringFromSpawnEgg(player, (class_1308)entity, serverLevel, entity.method_19538(), itemInHand);
                optional.ifPresent(mob -> ((ModMushroomCow)entity).method_18249(player, (class_1308)mob));
                if (optional.isEmpty()) {
                    return EventResultHolder.interrupt((Object)class_1269.field_5811);
                }
                return EventResultHolder.interrupt((Object)class_1269.field_21466);
            }
            return EventResultHolder.interrupt((Object)class_1269.field_5812);
        }
        return EventResultHolder.pass();
    }

    private static Optional<class_1308> spawnOffspringFromSpawnEgg(class_1657 player, class_1308 mob, class_3218 serverLevel, class_243 pos, class_1799 stack) {
        class_1296 mob2 = mob instanceof class_1296 ? ((class_1296)mob).method_5613(serverLevel, (class_1296)mob) : null;
        if (mob2 == null) {
            return Optional.empty();
        }
        mob2.method_7217(true);
        if (!mob2.method_6109()) {
            return Optional.empty();
        }
        mob2.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0f, 0.0f);
        serverLevel.method_30771((class_1297)mob2);
        mob2.method_5665((class_2561)stack.method_58694(class_9334.field_49631));
        stack.method_57008(1, (class_1309)player);
        return Optional.of(mob2);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_35113(class_1341.class::isInstance);
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, class_1438.class));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_VARIANT_ID, (Object)ColorVariant.BLUE);
    }

    public void method_5800(class_3218 serverLevel, class_1538 lightningBolt) {
        UUID uuid = lightningBolt.method_5667();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            ColorVariant[] colorVariants = this.getColorVariant().isNetherVariant() ? ColorVariant.getNetherVariants() : ColorVariant.getOverworldVariants();
            this.setColorVariant(colorVariants[(this.getColorVariant().typeIndex + 1) % colorVariants.length]);
            this.lastLightningBoltUUID = uuid;
            this.method_5783(class_3417.field_18266, 2.0f, 1.0f);
        }
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnGroupData) {
        ColorVariant variant;
        if (spawnGroupData instanceof MooshroomGroupData) {
            MooshroomGroupData mooshroomGroupData = (MooshroomGroupData)((Object)spawnGroupData);
            variant = mooshroomGroupData.variant;
        } else {
            variant = ModMushroomCow.getRandomVariant((class_1936)level, this.method_24515());
            spawnGroupData = new MooshroomGroupData(variant);
        }
        this.setColorVariant(variant);
        return super.method_5943(level, difficulty, spawnReason, spawnGroupData);
    }

    private static ColorVariant getRandomVariant(class_1936 level, class_2338 pos) {
        class_6880 holder = level.method_23753(pos);
        if (holder.method_40225(class_1972.field_22077)) {
            return ColorVariant.CRIMSON;
        }
        if (holder.method_40225(class_1972.field_22075)) {
            return ColorVariant.WARPED;
        }
        ColorVariant[] colorVariants = holder.method_40220(class_6908.field_36518) ? ColorVariant.getNetherVariants() : ColorVariant.getOverworldVariants();
        return (ColorVariant)((Object)class_156.method_27173((Object[])colorVariants, (class_5819)level.method_8409()));
    }

    protected void method_61419(class_3218 level, class_5321<class_52> lootTable, class_1799 shears, BiConsumer<class_3218, class_1799> dropConsumer) {
        super.method_61419(level, lootTable == class_39.field_54009 ? ModLootTables.SHEAR_MOOSHROOM_LOOT_TABLE : lootTable, shears, dropConsumer);
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71468(Shroomcraft.id("variant").toString(), ColorVariant.CODEC, (Object)this.getColorVariant());
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        valueInput.method_71426(Shroomcraft.id("variant").toString(), ColorVariant.CODEC).ifPresent(this::setColorVariant);
    }

    public class_1438.class_4053 method_47847() {
        return class_1438.class_4053.field_18109;
    }

    public void setColorVariant(ColorVariant colorVariant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)colorVariant);
    }

    public ColorVariant getColorVariant() {
        return (ColorVariant)((Object)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> dataComponentType) {
        return (T)(dataComponentType == ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.comp_349() ? ModMushroomCow.method_66651(dataComponentType, (Object)((Object)this.getColorVariant())) : super.method_58694(dataComponentType));
    }

    protected void method_66649(class_9473 dataComponentGetter) {
        this.method_66650(dataComponentGetter, (class_9331)ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.comp_349());
        super.method_66649(dataComponentGetter);
    }

    protected <T> boolean method_66654(class_9331<T> dataComponentType, T object) {
        if (dataComponentType == ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.comp_349()) {
            this.setColorVariant((ColorVariant)((Object)ModMushroomCow.method_66651((class_9331)((class_9331)ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.comp_349()), object)));
            return true;
        }
        return super.method_66654(dataComponentType, object);
    }

    @Nullable
    public class_1438 method_6495(class_3218 level, class_1296 otherParent) {
        ModMushroomCow modMushroomCow = (ModMushroomCow)this.method_5864().method_5883((class_1937)level, class_3730.field_16466);
        if (modMushroomCow != null) {
            modMushroomCow.setColorVariant(this.getColorVariant());
        }
        return modMushroomCow;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)class_1802.field_8299);
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        return otherAnimal instanceof class_1438 && this.method_6479() && otherAnimal.method_6479();
    }

    public static enum ColorVariant implements class_3542
    {
        BLUE(0, (class_6880<class_2248>)ModBlocks.BLUE_MUSHROOM),
        ORANGE(1, (class_6880<class_2248>)ModBlocks.ORANGE_MUSHROOM),
        PURPLE(2, (class_6880<class_2248>)ModBlocks.PURPLE_MUSHROOM),
        CRIMSON(0, (class_6880<class_2248>)class_2246.field_22121.method_40142()),
        WARPED(1, (class_6880<class_2248>)class_2246.field_22114.method_40142());

        public static final class_3542.class_8808<ColorVariant> CODEC;
        public static final class_9139<ByteBuf, ColorVariant> STREAM_CODEC;
        private final int typeIndex;
        public final class_6880<class_2248> block;

        private ColorVariant(int typeIndex, class_6880<class_2248> block) {
            this.typeIndex = typeIndex;
            this.block = block;
        }

        public static ColorVariant[] getOverworldVariants() {
            return (ColorVariant[])Arrays.stream(ColorVariant.values()).filter(ColorVariant::isOverworldVariant).toArray(ColorVariant[]::new);
        }

        public static ColorVariant[] getNetherVariants() {
            return (ColorVariant[])Arrays.stream(ColorVariant.values()).filter(ColorVariant::isNetherVariant).toArray(ColorVariant[]::new);
        }

        public boolean isOverworldVariant() {
            return !this.isNetherVariant();
        }

        public boolean isNetherVariant() {
            return this == CRIMSON || this == WARPED;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(ColorVariant::values);
            STREAM_CODEC = ExtraStreamCodecs.fromEnum(ColorVariant.class);
        }
    }

    static class MooshroomGroupData
    extends class_1296.class_4697 {
        public final ColorVariant variant;

        MooshroomGroupData(ColorVariant variant) {
            super(true);
            this.variant = variant;
        }
    }
}

