/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.data;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.data.v2.AbstractDatapackRegistriesProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.shroomcraft.init.ModBlocks;
import fuzs.shroomcraft.init.ModFeatures;
import fuzs.shroomcraft.init.ModRegistry;
import fuzs.shroomcraft.world.entity.animal.MobBlockVariant;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.jetbrains.annotations.Nullable;

public class ModDatapackRegistriesProvider
extends AbstractDatapackRegistriesProvider {
    public ModDatapackRegistriesProvider(DataProviderContext context) {
        super(context);
    }

    public void addBootstrap(AbstractDatapackRegistriesProvider.RegistryBoostrapConsumer consumer) {
        consumer.add(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY, ModDatapackRegistriesProvider::bootstrapCluckshroomVariants);
        consumer.add(Registries.CONFIGURED_FEATURE, ModDatapackRegistriesProvider::bootstrapConfiguredFeatures);
        consumer.add(Registries.PLACED_FEATURE, ModDatapackRegistriesProvider::bootstrapPlacedFeatures);
    }

    static void bootstrapCluckshroomVariants(BootstrapContext<MobBlockVariant> context) {
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        context.register(ModRegistry.RED_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.RED_CLUCKSHROOM_VARIANT, Blocks.RED_MUSHROOM));
        context.register(ModRegistry.BROWN_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.BROWN_CLUCKSHROOM_VARIANT, Blocks.BROWN_MUSHROOM));
        context.register(ModRegistry.CRIMSON_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.CRIMSON_CLUCKSHROOM_VARIANT, Blocks.CRIMSON_FUNGUS, (Holder<Biome>)biomeLookup.getOrThrow(Biomes.CRIMSON_FOREST)));
        context.register(ModRegistry.WARPED_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.WARPED_CLUCKSHROOM_VARIANT, Blocks.WARPED_FUNGUS, (Holder<Biome>)biomeLookup.getOrThrow(Biomes.WARPED_FOREST)));
        context.register(ModRegistry.BLUE_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.BLUE_CLUCKSHROOM_VARIANT, (Block)ModBlocks.BLUE_MUSHROOM.value()));
        context.register(ModRegistry.ORANGE_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.ORANGE_CLUCKSHROOM_VARIANT, (Block)ModBlocks.ORANGE_MUSHROOM.value()));
        context.register(ModRegistry.PURPLE_CLUCKSHROOM_VARIANT, (Object)new MobBlockVariant(ModRegistry.CLUCKSHROOM_ENTITY_TYPE, ModRegistry.PURPLE_CLUCKSHROOM_VARIANT, (Block)ModBlocks.PURPLE_MUSHROOM.value()));
    }

    static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, ModFeatures.HUGE_BLUE_MUSHROOM_CONFIGURED_FEATURE, (Feature)((Feature)ModFeatures.HUGE_BLUE_MUSHROOM_FEATURE.value()), (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.BLUE_MUSHROOM_BLOCK.value()).defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)((Block)ModBlocks.BLUE_MUSHROOM_STEM.value()).defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.FALSE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), 3));
        FeatureUtils.register(context, ModFeatures.HUGE_ORANGE_MUSHROOM_CONFIGURED_FEATURE, (Feature)((Feature)ModFeatures.HUGE_ORANGE_MUSHROOM_FEATURE.value()), (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.ORANGE_MUSHROOM_BLOCK.value()).defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)((Block)ModBlocks.ORANGE_MUSHROOM_STEM.value()).defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.FALSE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), 3));
        FeatureUtils.register(context, ModFeatures.HUGE_PURPLE_MUSHROOM_CONFIGURED_FEATURE, (Feature)((Feature)ModFeatures.HUGE_PURPLE_MUSHROOM_FEATURE.value()), (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.PURPLE_MUSHROOM_BLOCK.value()).defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)((Block)ModBlocks.PURPLE_MUSHROOM_STEM.value()).defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.FALSE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), 3));
        HolderGetter configuredFeatureLookup = context.lookup(Registries.CONFIGURED_FEATURE);
        FeatureUtils.register(context, ModFeatures.MUSHROOM_ISLAND_VEGETATION_CONFIGURED_FEATURE, (Feature)Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Holder)configuredFeatureLookup.getOrThrow(TreeFeatures.HUGE_BROWN_MUSHROOM), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)configuredFeatureLookup.getOrThrow(TreeFeatures.HUGE_RED_MUSHROOM), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)configuredFeatureLookup.getOrThrow(ModFeatures.HUGE_BLUE_MUSHROOM_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)configuredFeatureLookup.getOrThrow(ModFeatures.HUGE_ORANGE_MUSHROOM_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Holder)configuredFeatureLookup.getOrThrow(ModFeatures.HUGE_PURPLE_MUSHROOM_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[0])})));
        FeatureUtils.register(context, ModFeatures.PATCH_BLUE_MUSHROOM_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.BLUE_MUSHROOM.value())))));
        FeatureUtils.register(context, ModFeatures.PATCH_ORANGE_MUSHROOM_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.ORANGE_MUSHROOM.value())))));
        FeatureUtils.register(context, ModFeatures.PATCH_PURPLE_MUSHROOM_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.PURPLE_MUSHROOM.value())))));
        FeatureUtils.register(context, ModFeatures.MYCELIAL_GROWTH_CONFIGURED_FEATURE, (Feature)Feature.MULTIFACE_GROWTH, (FeatureConfiguration)new MultifaceGrowthConfiguration((MultifaceSpreadeableBlock)ModBlocks.MYCELIAL_GROWTH.value(), 20, true, true, true, 1.0f, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{Blocks.STONE, Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.DRIPSTONE_BLOCK, Blocks.CALCITE, Blocks.TUFF, Blocks.DEEPSLATE})));
        FeatureUtils.register(context, ModFeatures.PATCH_MUSHROOM_SPROUTS_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.MUSHROOM_SPROUTS.value())))));
        FeatureUtils.register(context, ModFeatures.PATCH_BLUE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.BLUE_MUSHROOM_SPROUTS.value())))));
        FeatureUtils.register(context, ModFeatures.PATCH_ORANGE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.ORANGE_MUSHROOM_SPROUTS.value())))));
        FeatureUtils.register(context, ModFeatures.PATCH_PURPLE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.PURPLE_MUSHROOM_SPROUTS.value())))));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider stateProvider, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureLookup = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, ModFeatures.MUSHROOM_ISLAND_VEGETATION_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.MUSHROOM_ISLAND_VEGETATION_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, ModFeatures.BLUE_MUSHROOM_NORMAL_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_BLUE_MUSHROOM_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(384, null));
        PlacementUtils.register(context, ModFeatures.ORANGE_MUSHROOM_NORMAL_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_ORANGE_MUSHROOM_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(384, null));
        PlacementUtils.register(context, ModFeatures.PURPLE_MUSHROOM_NORMAL_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_PURPLE_MUSHROOM_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(384, null));
        PlacementUtils.register(context, ModFeatures.BLUE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_BLUE_MUSHROOM_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(64, null));
        PlacementUtils.register(context, ModFeatures.ORANGE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_ORANGE_MUSHROOM_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(64, null));
        PlacementUtils.register(context, ModFeatures.PURPLE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_PURPLE_MUSHROOM_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(64, null));
        PlacementUtils.register(context, ModFeatures.MYCELIAL_GROWTH_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.MYCELIAL_GROWTH_CONFIGURED_FEATURE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)204, (int)250)), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, InSquarePlacement.spread(), BiomeFilter.biome()});
        PlacementUtils.register(context, ModFeatures.PATCH_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(16, null));
        PlacementUtils.register(context, ModFeatures.PATCH_BLUE_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_BLUE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(16, null));
        PlacementUtils.register(context, ModFeatures.PATCH_ORANGE_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_ORANGE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(16, null));
        PlacementUtils.register(context, ModFeatures.PATCH_PURPLE_MUSHROOM_SPROUTS_PLACED_FEATURE, (Holder)configuredFeatureLookup.getOrThrow(ModFeatures.PATCH_PURPLE_MUSHROOM_SPROUTS_CONFIGURED_FEATURE), ModDatapackRegistriesProvider.getMushroomPlacement(16, null));
    }

    private static List<PlacementModifier> getMushroomPlacement(int rarity, @Nullable PlacementModifier placement) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (placement != null) {
            builder.add((Object)placement);
        }
        if (rarity != 0) {
            builder.add((Object)RarityFilter.onAverageOnceEvery((int)rarity));
        }
        builder.add((Object)InSquarePlacement.spread());
        builder.add((Object)PlacementUtils.HEIGHTMAP);
        builder.add((Object)BiomeFilter.biome());
        return builder.build();
    }
}

