/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.entity.animal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;

public record MobBlockVariant(ResourceLocation textureLocation, BlockState blockState, ResourceKey<LootTable> shearingLootTable, HolderSet<Biome> biomes) {
    public static final Codec<MobBlockVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(MobBlockVariant::textureLocation), (App)BlockState.CODEC.fieldOf("carried_block").forGetter(MobBlockVariant::blockState), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("shearing_loot_table").forGetter(MobBlockVariant::shearingLootTable), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes", (Object)HolderSet.empty()).forGetter(MobBlockVariant::biomes)).apply((Applicative)instance, MobBlockVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobBlockVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, MobBlockVariant::textureLocation, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), MobBlockVariant::blockState, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE), MobBlockVariant::shearingLootTable, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME), MobBlockVariant::biomes, MobBlockVariant::new);

    public MobBlockVariant(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<MobBlockVariant> resourceKey, Block block) {
        this(entityType, resourceKey, block, (HolderSet<Biome>)HolderSet.empty());
    }

    public MobBlockVariant(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<MobBlockVariant> resourceKey, Block block, Holder<Biome> biome) {
        this(entityType, resourceKey, block, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biome}));
    }

    public MobBlockVariant(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<MobBlockVariant> resourceKey, Block block, HolderSet<Biome> biomes) {
        this(MobBlockVariant.getTextureLocation(entityType, resourceKey), block.defaultBlockState(), MobBlockVariant.getShearingLootTable(entityType, resourceKey), biomes);
    }

    public static Codec<Holder<MobBlockVariant>> codec(ResourceKey<Registry<MobBlockVariant>> registryKey) {
        return RegistryFileCodec.create(registryKey, DIRECT_CODEC);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Holder<MobBlockVariant>> streamCodec(ResourceKey<Registry<MobBlockVariant>> registryKey) {
        return ByteBufCodecs.holder(registryKey, DIRECT_STREAM_CODEC);
    }

    public static ResourceLocation transformTextureLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPath(string -> "textures/" + string + ".png");
    }

    public static ResourceLocation getTextureLocation(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<MobBlockVariant> resourceKey) {
        String path = entityType.key().location().getPath();
        return resourceKey.location().withPath(string -> "entity/" + path + "/" + string + "_" + path);
    }

    public static ResourceKey<LootTable> getShearingLootTable(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<MobBlockVariant> resourceKey) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceKey.location().withPath(string -> "shearing/" + entityType.key().location().getPath() + "/" + string));
    }
}

