/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.item.crafting;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.level.Level;

public class ShroombombItem
extends LingeringPotionItem {
    public ShroombombItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        return (Component)stack.getComponents().getOrDefault(DataComponents.ITEM_NAME, (Object)CommonComponents.EMPTY);
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LINGERING_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation(LingeringThrownPotion::new, (ServerLevel)serverLevel, (ItemStack)itemInHand, (LivingEntity)player, (float)-10.0f, (float)0.5f, (float)1.0f);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemInHand.consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack itemStack, Direction direction) {
        return new LingeringThrownPotion(level, pos.x(), pos.y(), pos.z(), itemStack);
    }

    private static class LingeringThrownPotion
    extends ThrownPotion {
        public LingeringThrownPotion(Level level, LivingEntity owner, ItemStack item) {
            super(level, owner, item);
        }

        public LingeringThrownPotion(Level level, double x, double y, double z, ItemStack item) {
            super(level, x, y, z, item);
        }

        protected boolean isLingering() {
            return true;
        }
    }
}

