/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft;

import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CompostableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.DataPackRegistriesContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.shroomcraft.handler.AxeStrippingHandler;
import fuzs.shroomcraft.init.ModBlockFamilies;
import fuzs.shroomcraft.init.ModFeatures;
import fuzs.shroomcraft.init.ModItems;
import fuzs.shroomcraft.init.ModRegistry;
import fuzs.shroomcraft.world.entity.animal.Cluckshroom;
import fuzs.shroomcraft.world.entity.animal.MobBlockVariant;
import fuzs.shroomcraft.world.entity.animal.ModMushroomCow;
import java.util.Objects;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shroomcraft
implements ModConstructor {
    public static final String MOD_ID = "shroomcraft";
    public static final String MOD_NAME = "Shroomcraft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Shroomcraft");

    public void onConstructMod() {
        ModRegistry.bootstrap();
        Shroomcraft.registerEventHandler();
    }

    private static void registerEventHandler() {
        PlayerInteractEvents.USE_BLOCK.register(AxeStrippingHandler::onUseBlock);
        AddBlockEntityTypeBlocksCallback.EVENT.register(consumer -> {
            ModBlockFamilies.getAllFamilyRegistrars().mapMulti((registrar, blockConsumer) -> {
                blockConsumer.accept(registrar.getBlock(BlockFamily.Variant.SIGN));
                blockConsumer.accept(registrar.getBlock(BlockFamily.Variant.WALL_SIGN));
            }).filter(Objects::nonNull).map(Holder::value).forEach(block -> consumer.accept(BlockEntityType.SIGN, block));
            ModBlockFamilies.getAllFamilyRegistrars().mapMulti((registrar, blockConsumer) -> {
                blockConsumer.accept(registrar.hangingSignBlock());
                blockConsumer.accept(registrar.wallHangingSignBlock());
            }).filter(Objects::nonNull).map(Holder::value).forEach(block -> consumer.accept(BlockEntityType.HANGING_SIGN, block));
        });
        ServerEntityLevelEvents.SPAWN.register(ModMushroomCow::onEntitySpawn);
        PlayerInteractEvents.USE_ENTITY.register(ModMushroomCow::onEntityInteract);
        LootTableLoadCallback.EVENT.register((resourceLocation, lootTable, registries) -> {
            if (BuiltInLootTables.FISHING_FISH.location().equals((Object)resourceLocation)) {
                MutableBoolean mutableBoolean = new MutableBoolean();
                LootTableLoadCallback.forEachPool((LootTable.Builder)lootTable, builder -> {
                    if (mutableBoolean.isFalse()) {
                        mutableBoolean.setTrue();
                        LootPoolSingletonContainer.Builder entriesBuilder = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SHROOMFIN.value())).setWeight(15);
                        if (registries != null) {
                            entriesBuilder.when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{registries.lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.MUSHROOM_FIELDS)}))));
                        }
                        builder.add((LootPoolEntryContainer.Builder)entriesBuilder);
                    }
                });
            }
        });
    }

    public void onCommonSetup() {
        ModBlockFamilies.getAllFamilyRegistrars().forEach(registrar -> {
            BlockSetType.register((BlockSetType)registrar.getBlockSetType());
            WoodType.register((WoodType)registrar.getWoodType());
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.SHROOMFIN_BUCKET.value()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

            public ItemStack execute(BlockSource blockSource, ItemStack item) {
                DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)item.getItem();
                BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = blockSource.level();
                if (dispensibleContainerItem.emptyContents(null, (Level)level, blockPos, null)) {
                    dispensibleContainerItem.checkExtraContent(null, (Level)level, item, blockPos);
                    return this.consumeWithRemainder(blockSource, item, new ItemStack((ItemLike)Items.BUCKET));
                }
                return super.execute(blockSource, item);
            }
        });
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ModItems.BLUE_SHROOMBOMB.value()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ModItems.ORANGE_SHROOMBOMB.value()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ModItems.PURPLE_SHROOMBOMB.value()));
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.MOOSHROOM_ENTITY_TYPE.value(), Cow.createAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.SHROOMFIN_ENTITY_TYPE.value(), AbstractFish.createAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.CLUCKSHROOM_ENTITY_TYPE.value(), Chicken.createAttributes());
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.MOOSHROOM_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModMushroomCow::checkCustomMushroomSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.SHROOMFIN_ENTITY_TYPE.value(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.CLUCKSHROOM_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Cluckshroom::checkMushroomSpawnRules);
    }

    public void onDataPackRegistriesContext(DataPackRegistriesContext context) {
        context.registerSynced(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY, MobBlockVariant.DIRECT_CODEC);
    }

    public void onRegisterCompostableBlocks(CompostableBlocksContext context) {
        context.registerCompostable(0.3f, new Holder[]{ModItems.BROWN_SHROOMSPORES, ModItems.RED_SHROOMSPORES, ModItems.BLUE_SHROOMSPORES, ModItems.ORANGE_SHROOMSPORES, ModItems.PURPLE_SHROOMSPORES});
        context.registerCompostable(0.5f, new Holder[]{ModItems.MYCELIAL_GROWTH, ModItems.MUSHROOM_SPROUTS, ModItems.BLUE_MUSHROOM_SPROUTS, ModItems.ORANGE_MUSHROOM_SPROUTS, ModItems.PURPLE_MUSHROOM_SPROUTS});
        context.registerCompostable(0.65f, new Holder[]{ModItems.BLUE_MUSHROOM, ModItems.ORANGE_MUSHROOM, ModItems.PURPLE_MUSHROOM, ModItems.BLUE_MUSHROOM_STEM, ModItems.ORANGE_MUSHROOM_STEM, ModItems.PURPLE_MUSHROOM_STEM});
        context.registerCompostable(0.85f, new Holder[]{ModItems.BLUE_MUSHROOM_BLOCK, ModItems.ORANGE_MUSHROOM_BLOCK, ModItems.PURPLE_MUSHROOM_BLOCK});
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> biomeLoadingContext.is(Biomes.CRIMSON_FOREST), biomeModificationContext -> biomeModificationContext.mobSpawnSettings().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.MOOSHROOM_ENTITY_TYPE.value(), 8, 4, 8)));
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> biomeLoadingContext.is(Biomes.WARPED_FOREST), biomeModificationContext -> biomeModificationContext.mobSpawnSettings().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.MOOSHROOM_ENTITY_TYPE.value(), 8, 4, 8)));
        context.register(BiomeLoadingPhase.MODIFICATIONS, biomeLoadingContext -> biomeLoadingContext.is(Biomes.MUSHROOM_FIELDS), biomeModificationContext -> {
            biomeModificationContext.generationSettings().removeFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.MUSHROOM_ISLAND_VEGETATION);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.MUSHROOM_ISLAND_VEGETATION_PLACED_FEATURE);
        });
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> biomeLoadingContext.is(Biomes.MUSHROOM_FIELDS), biomeModificationContext -> {
            biomeModificationContext.mobSpawnSettings().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.MOOSHROOM_ENTITY_TYPE.value(), 8, 4, 8));
            biomeModificationContext.mobSpawnSettings().addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.SHROOMFIN_ENTITY_TYPE.value(), 5, 1, 5));
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.MYCELIAL_GROWTH_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.BLUE_MUSHROOM_NORMAL_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.ORANGE_MUSHROOM_NORMAL_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PURPLE_MUSHROOM_NORMAL_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.BLUE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.ORANGE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PURPLE_MUSHROOM_MUSHROOM_FIELDS_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PATCH_MUSHROOM_SPROUTS_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PATCH_BLUE_MUSHROOM_SPROUTS_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PATCH_ORANGE_MUSHROOM_SPROUTS_PLACED_FEATURE);
            biomeModificationContext.generationSettings().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PATCH_PURPLE_MUSHROOM_SPROUTS_PLACED_FEATURE);
        });
    }

    public ContentRegistrationFlags[] getContentRegistrationFlags() {
        return new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOME_MODIFICATIONS};
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

