/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.shroomcraft.Shroomcraft;
import fuzs.shroomcraft.client.init.ModModelLayers;
import fuzs.shroomcraft.client.model.ShroomfinModel;
import fuzs.shroomcraft.world.entity.animal.Shroomfin;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ShroomfinRenderer
extends MobRenderer<Shroomfin, LivingEntityRenderState, ShroomfinModel> {
    private static final ResourceLocation TEXTURE_LOCATION = Shroomcraft.id("textures/entity/fish/shroomfin.png");

    public ShroomfinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ShroomfinModel(context.bakeLayer(ModModelLayers.SHROOMFIN)), 0.3f);
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    protected void setupRotations(LivingEntityRenderState renderState, PoseStack poseStack, float bodyRot, float scale) {
        super.setupRotations(renderState, poseStack, bodyRot, scale);
        float f = 4.3f * Mth.sin((float)(0.6f * renderState.ageInTicks));
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!renderState.isInWater) {
            poseStack.translate(0.1f, 0.1f, -0.1f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

