/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.data.tags;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagProvider;
import fuzs.shroomcraft.init.ModBlockFamilies;
import fuzs.shroomcraft.init.ModBlocks;
import fuzs.shroomcraft.init.ModRegistry;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModBlockTagProvider
extends AbstractTagProvider<Block> {
    static final Map<BlockFamily.Variant, TagKey<Block>> VARIANT_TAGS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (Object)BlockTags.BUTTONS).put((Object)BlockFamily.Variant.DOOR, (Object)BlockTags.DOORS).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (Object)BlockTags.FENCES).put((Object)BlockFamily.Variant.FENCE, (Object)BlockTags.FENCES).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (Object)BlockTags.FENCE_GATES).put((Object)BlockFamily.Variant.FENCE_GATE, (Object)BlockTags.FENCE_GATES).put((Object)BlockFamily.Variant.SIGN, (Object)BlockTags.STANDING_SIGNS).put((Object)BlockFamily.Variant.SLAB, (Object)BlockTags.SLABS).put((Object)BlockFamily.Variant.STAIRS, (Object)BlockTags.STAIRS).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (Object)BlockTags.PRESSURE_PLATES).put((Object)BlockFamily.Variant.TRAPDOOR, (Object)BlockTags.TRAPDOORS).put((Object)BlockFamily.Variant.WALL, (Object)BlockTags.WALLS).put((Object)BlockFamily.Variant.WALL_SIGN, (Object)BlockTags.WALL_SIGNS).build();
    static final Map<BlockFamily.Variant, TagKey<Block>> VARIANT_STONE_TAGS = ImmutableMap.builder().putAll(VARIANT_TAGS).put((Object)BlockFamily.Variant.BUTTON, (Object)BlockTags.STONE_BUTTONS).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (Object)BlockTags.STONE_PRESSURE_PLATES).buildKeepingLast();
    static final Map<BlockFamily.Variant, TagKey<Block>> VARIANT_WOODEN_TAGS = ImmutableMap.builder().putAll(VARIANT_TAGS).put((Object)BlockFamily.Variant.BUTTON, (Object)BlockTags.WOODEN_BUTTONS).put((Object)BlockFamily.Variant.DOOR, (Object)BlockTags.WOODEN_DOORS).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (Object)BlockTags.WOODEN_FENCES).put((Object)BlockFamily.Variant.FENCE, (Object)BlockTags.WOODEN_FENCES).put((Object)BlockFamily.Variant.SLAB, (Object)BlockTags.WOODEN_SLABS).put((Object)BlockFamily.Variant.STAIRS, (Object)BlockTags.WOODEN_STAIRS).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (Object)BlockTags.WOODEN_PRESSURE_PLATES).put((Object)BlockFamily.Variant.TRAPDOOR, (Object)BlockTags.WOODEN_TRAPDOORS).buildKeepingLast();

    public ModBlockTagProvider(DataProviderContext context) {
        super(Registries.BLOCK, context);
    }

    public void addTags(HolderLookup.Provider registries) {
        this.add(BlockTags.PLANKS).add((Object[])new Block[]{(Block)ModBlocks.SHROOMWOOD_PLANKS.value(), (Block)ModBlocks.BLUE_SHROOMWOOD_PLANKS.value(), (Block)ModBlocks.ORANGE_SHROOMWOOD_PLANKS.value(), (Block)ModBlocks.PURPLE_SHROOMWOOD_PLANKS.value()});
        ModBlockFamilies.getAllFamilyRegistrars().forEach(registrar -> {
            for (Map.Entry<BlockFamily.Variant, TagKey<Block>> entry : VARIANT_WOODEN_TAGS.entrySet()) {
                Holder.Reference<Block> block = registrar.getBlock(entry.getKey());
                if (block == null) continue;
                this.add(entry.getValue()).add(block);
            }
        });
        ModBlockFamilies.getAllFamilyRegistrars().forEach(registrar -> {
            if (registrar.hangingSignBlock() != null) {
                this.add(BlockTags.CEILING_HANGING_SIGNS).add(registrar.hangingSignBlock());
            }
            if (registrar.wallHangingSignBlock() != null) {
                this.add(BlockTags.WALL_HANGING_SIGNS).add(registrar.wallHangingSignBlock());
            }
        });
        this.add(BlockTags.MINEABLE_WITH_AXE).add((Object[])new Block[]{(Block)ModBlocks.BLUE_MUSHROOM.value(), (Block)ModBlocks.ORANGE_MUSHROOM.value(), (Block)ModBlocks.PURPLE_MUSHROOM.value()}).add((Object[])new Block[]{(Block)ModBlocks.BLUE_MUSHROOM_BLOCK.value(), (Block)ModBlocks.ORANGE_MUSHROOM_BLOCK.value(), (Block)ModBlocks.PURPLE_MUSHROOM_BLOCK.value(), (Block)ModBlocks.BLUE_MUSHROOM_STEM.value(), (Block)ModBlocks.ORANGE_MUSHROOM_STEM.value(), (Block)ModBlocks.PURPLE_MUSHROOM_STEM.value()});
        this.add(BlockTags.LOGS_THAT_BURN).addTag(new TagKey[]{ModRegistry.SHROOMWOOD_LOGS_BLOCK_TAG, ModRegistry.BLUE_SHROOMWOOD_LOGS_BLOCK_TAG, ModRegistry.ORANGE_SHROOMWOOD_LOGS_BLOCK_TAG, ModRegistry.PURPLE_SHROOMWOOD_LOGS_BLOCK_TAG});
        this.add(ModRegistry.SHROOMWOOD_LOGS_BLOCK_TAG).add((Object[])new Block[]{(Block)ModBlocks.STRIPPED_MUSHROOM_STEM.value(), (Block)ModBlocks.STRIPPED_MUSHROOM_HYPHAE.value()});
        this.add(ModRegistry.BLUE_SHROOMWOOD_LOGS_BLOCK_TAG).add((Object[])new Block[]{(Block)ModBlocks.STRIPPED_BLUE_MUSHROOM_STEM.value(), (Block)ModBlocks.STRIPPED_BLUE_MUSHROOM_HYPHAE.value()});
        this.add(ModRegistry.ORANGE_SHROOMWOOD_LOGS_BLOCK_TAG).add((Object[])new Block[]{(Block)ModBlocks.STRIPPED_ORANGE_MUSHROOM_STEM.value(), (Block)ModBlocks.STRIPPED_ORANGE_MUSHROOM_HYPHAE.value()});
        this.add(ModRegistry.PURPLE_SHROOMWOOD_LOGS_BLOCK_TAG).add((Object[])new Block[]{(Block)ModBlocks.STRIPPED_PURPLE_MUSHROOM_STEM.value(), (Block)ModBlocks.STRIPPED_PURPLE_MUSHROOM_HYPHAE.value()});
        this.add(BlockTags.CROPS).add((Object[])new Block[]{(Block)ModBlocks.TINY_BROWN_MUSHROOM.value(), (Block)ModBlocks.TINY_RED_MUSHROOM.value(), (Block)ModBlocks.TINY_BLUE_MUSHROOM.value(), (Block)ModBlocks.TINY_ORANGE_MUSHROOM.value(), (Block)ModBlocks.TINY_PURPLE_MUSHROOM.value()});
        this.add(BlockTags.FLOWER_POTS).add((Object[])new Block[]{(Block)ModBlocks.POTTED_BLUE_MUSHROOM.value(), (Block)ModBlocks.POTTED_ORANGE_MUSHROOM.value(), (Block)ModBlocks.POTTED_PURPLE_MUSHROOM.value()});
        this.add(BlockTags.ENDERMAN_HOLDABLE).add((Object[])new Block[]{(Block)ModBlocks.BLUE_MUSHROOM.value(), (Block)ModBlocks.ORANGE_MUSHROOM.value(), (Block)ModBlocks.PURPLE_MUSHROOM.value()}).add((Object[])new Block[]{(Block)ModBlocks.MUSHROOM_SPROUTS.value(), (Block)ModBlocks.BLUE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.ORANGE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.PURPLE_MUSHROOM_SPROUTS.value()});
        this.add(BlockTags.REPLACEABLE_BY_TREES).add((Object[])new Block[]{(Block)ModBlocks.MUSHROOM_SPROUTS.value(), (Block)ModBlocks.BLUE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.ORANGE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.PURPLE_MUSHROOM_SPROUTS.value()});
        this.add(BlockTags.COMBINATION_STEP_SOUND_BLOCKS).add((Object[])new Block[]{(Block)ModBlocks.MUSHROOM_SPROUTS.value(), (Block)ModBlocks.BLUE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.ORANGE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.PURPLE_MUSHROOM_SPROUTS.value()});
        this.add(BlockTags.SWORD_EFFICIENT).add((Object[])new Block[]{(Block)ModBlocks.MUSHROOM_SPROUTS.value(), (Block)ModBlocks.BLUE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.ORANGE_MUSHROOM_SPROUTS.value(), (Block)ModBlocks.PURPLE_MUSHROOM_SPROUTS.value()}).add((Object[])new Block[]{(Block)ModBlocks.BLUE_MUSHROOM.value(), (Block)ModBlocks.ORANGE_MUSHROOM.value(), (Block)ModBlocks.PURPLE_MUSHROOM.value()});
        this.add(BlockTags.MOOSHROOMS_SPAWNABLE_ON).add((Object[])new Block[]{Blocks.CRIMSON_NYLIUM, Blocks.WARPED_NYLIUM});
    }
}

