/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.shroomcraft.init.ModRegistry;
import fuzs.shroomcraft.world.entity.animal.MobBlockVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class Cluckshroom
extends Chicken
implements Shearable,
VariantHolder<Holder<MobBlockVariant>> {
    private static final EntityDataAccessor<Holder<MobBlockVariant>> DATA_TYPE = SynchedEntityData.defineId(Cluckshroom.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.CLUCKSHROOM_VARIANT_ENTITY_DATA_SERIALIZER.value()));
    @Nullable
    private UUID lastLightningBoltUUID;

    public Cluckshroom(EntityType<? extends Chicken> entityType, Level level) {
        super(entityType, level);
    }

    public static boolean checkMushroomSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && Cluckshroom.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(WaterAvoidingRandomStrollGoal.class::isInstance);
        this.goalSelector.addGoal(5, (Goal)new CluckshroomRandomStrollGoal(this, 1.0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry registry = this.registryAccess().lookupOrThrow(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY);
        builder.define(DATA_TYPE, (Object)((Holder)registry.get(ModRegistry.RED_CLUCKSHROOM_VARIANT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(Items.BOWL) && !this.isBaby()) {
            ItemStack newItemInHand = ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.MUSHROOM_STEW), (boolean)false);
            player.setItemInHand(hand, newItemInHand);
            this.playSound(SoundEvents.MOOSHROOM_MILK, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.is(Items.SHEARS) && this.readyForShearing()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shear(serverLevel, SoundSource.PLAYERS, itemInHand);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemInHand.hurtAndBreak(1, (LivingEntity)player, Cluckshroom.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void aiStep() {
        this.eggTime = 6000;
        super.aiStep();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        Holder<MobBlockVariant> variant;
        if (spawnGroupData instanceof MobBlockVariantGroupData) {
            MobBlockVariantGroupData mobBlockVariantGroupData = (MobBlockVariantGroupData)((Object)spawnGroupData);
            variant = mobBlockVariantGroupData.variant;
        } else {
            Holder biome = level.getBiome(this.blockPosition());
            variant = Cluckshroom.getSpawnVariant(this.registryAccess(), (Holder<Biome>)biome);
            spawnGroupData = new MobBlockVariantGroupData(variant);
        }
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    public static Holder<MobBlockVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> biome) {
        Registry registry = registryAccess.lookupOrThrow(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY);
        return Cluckshroom.getRandomSpawnVariant((Registry<MobBlockVariant>)registry, holder -> ((MobBlockVariant)holder.value()).biomes().contains(biome)).or(() -> Cluckshroom.getRandomSpawnVariant((Registry<MobBlockVariant>)registry, holder -> {
            TagKey<MobBlockVariant> tagKey = biome.is(BiomeTags.IS_NETHER) ? ModRegistry.NETHER_SPAWNS_CLUCKSHROOM_VARIANT_TAG : ModRegistry.DEFAULT_SPAWNS_CLUCKSHROOM_VARIANT_TAG;
            return holder.is(tagKey);
        })).or(() -> registry.get(ModRegistry.RED_CLUCKSHROOM_VARIANT)).or(() -> ((Registry)registry).getAny()).orElseThrow();
    }

    static Optional<Holder<MobBlockVariant>> getRandomSpawnVariant(Registry<MobBlockVariant> registry, Predicate<Holder<MobBlockVariant>> filter) {
        return Optional.ofNullable((Holder)registry.listElements().filter(filter).collect(Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), list -> {
            Collections.shuffle(list);
            return !list.isEmpty() ? (Holder.Reference)list.getFirst() : null;
        })));
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightningBolt) {
        UUID uuid = lightningBolt.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            Registry registry = this.registryAccess().lookupOrThrow(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY);
            int newIndex = (registry.getIdOrThrow((Object)((MobBlockVariant)this.getVariant().value())) + 1) % registry.size();
            this.setVariant((Holder<MobBlockVariant>)((Holder)registry.get(newIndex).orElseThrow(NoSuchElementException::new)));
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    public void shear(ServerLevel level, SoundSource soundSource, ItemStack shears) {
        level.playSound(null, (Entity)this, SoundEvents.MOOSHROOM_SHEAR, soundSource, 1.0f, 1.0f);
        this.convertTo(EntityType.CHICKEN, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), cow -> {
            level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(level, ((MobBlockVariant)this.getVariant().value()).shearingLootTable(), shears, (serverLevelx, itemStackx) -> {
                for (int i = 0; i < itemStackx.getCount(); ++i) {
                    serverLevelx.addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), itemStackx.copyWithCount(1)));
                }
            });
        });
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    public void setVariant(Holder<MobBlockVariant> variant) {
        this.entityData.set(DATA_TYPE, variant);
    }

    public Holder<MobBlockVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_TYPE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        MobBlockVariant.codec(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY).encodeStart((DynamicOps)NbtOps.INSTANCE, this.getVariant()).ifSuccess(tagX -> tag.put("variant", tagX));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        MobBlockVariant.codec(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY).parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("variant")).ifSuccess(this::setVariant);
    }

    @Nullable
    public Cluckshroom getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        Cluckshroom cluckshroom = (Cluckshroom)this.getType().create((Level)level, EntitySpawnReason.BREEDING);
        if (cluckshroom != null) {
            cluckshroom.setVariant(this.getVariant());
        }
        return cluckshroom;
    }

    public static class CluckshroomRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public <T extends PathfinderMob> CluckshroomRandomStrollGoal(T mob, double speedModifier) {
            super(mob, speedModifier);
        }

        public void tick() {
            ServerLevel serverLevel = CluckshroomRandomStrollGoal.getServerLevel((Entity)this.mob);
            if (CommonAbstractions.INSTANCE.getMobGriefingRule(serverLevel, (Entity)this.mob) && !this.mob.isBaby() && serverLevel.random.nextInt(1000) == 0 && this.mob.getDeltaMovement().lengthSqr() > (double)1.0E-5f) {
                BlockPos blockPos = this.mob.blockPosition();
                BlockState blockState = ((MobBlockVariant)((Holder)((VariantHolder)this.mob).getVariant()).value()).blockState();
                if (serverLevel.getBlockState(blockPos).isAir() && blockState.canSurvive((LevelReader)serverLevel, blockPos)) {
                    serverLevel.setBlockAndUpdate(blockPos, blockState);
                    SoundType soundType = blockState.getSoundType();
                    serverLevel.playSound(null, blockPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                    serverLevel.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockPos, GameEvent.Context.of((Entity)this.mob, (BlockState)blockState));
                }
            }
        }
    }

    public static class MobBlockVariantGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<MobBlockVariant> variant;

        public MobBlockVariantGroupData(Holder<MobBlockVariant> variant) {
            this(variant, true);
        }

        public MobBlockVariantGroupData(Holder<MobBlockVariant> variant, boolean shouldSpawnBaby) {
            super(shouldSpawnBaby);
            this.variant = variant;
        }
    }
}

