/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista;

import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.vista.VistaModClient;
import net.mehvahdjukaar.vista.client.TapeTextureManager;
import net.mehvahdjukaar.vista.common.CassetteItem;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.common.CassetteTapeLootFunction;
import net.mehvahdjukaar.vista.common.HollowCassetteItem;
import net.mehvahdjukaar.vista.common.ModLootOverrides;
import net.mehvahdjukaar.vista.common.TVBlock;
import net.mehvahdjukaar.vista.common.TVBlockEntity;
import net.mehvahdjukaar.vista.common.TelevisionItem;
import net.mehvahdjukaar.vista.common.ViewFinderBlock;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.mehvahdjukaar.vista.common.ViewFinderConnection;
import net.mehvahdjukaar.vista.configs.CommonConfigs;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.mehvahdjukaar.vista.network.ModNetwork;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VistaMod {
    public static final String MOD_ID = "vista";
    public static final Logger LOGGER = LogManager.getLogger((String)"Vista");
    public static final boolean EXPOSURE_ON = PlatHelper.isModLoaded((String)"exposure");
    public static final WorldSavedDataType<ViewFinderConnection> VIEWFINDER_CONNECTION = RegHelper.registerWorldSavedData((ResourceLocation)VistaMod.res("viewfinder_connection"), ViewFinderConnection::create, ViewFinderConnection.CODEC, ViewFinderConnection.STREAM_CODEC);
    public static final ResourceKey<Registry<CassetteTape>> CASSETTE_TAPE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)VistaMod.res("cassette_tape"));
    public static final Supplier<Block> TV;
    public static final Supplier<BlockItem> TV_ITEM;
    public static final Supplier<BlockEntityType<TVBlockEntity>> TV_TILE;
    public static final Supplier<Block> VIEWFINDER;
    public static final Supplier<BlockEntityType<ViewFinderBlockEntity>> VIEWFINDER_TILE;
    public static final Supplier<CassetteItem> CASSETTE;
    public static final Supplier<HollowCassetteItem> HOLLOW_CASSETTE;
    public static final Supplier<DataComponentType<UUID>> LINKED_FEED_COMPONENT;
    public static final Supplier<DataComponentType<Holder<CassetteTape>>> CASSETTE_TAPE_COMPONENT;
    public static final Supplier<SoundEvent> CASSETTE_INSERT_SOUND;
    public static final Supplier<SoundEvent> CASSETTE_EJECT_SOUND;
    public static final RegSupplier<SoundEvent> TV_STATIC_SOUND;
    public static final int STATIC_SOUND_DURATION = 80;
    public static final Supplier<LootItemFunctionType<CassetteTapeLootFunction>> CASSETTE_TAPE_LOOT_FUNCTION;
    public static final TagKey<CassetteTape> SUPPORTER_TAPES;

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void init() {
        CommonConfigs.init();
        ModNetwork.init();
        ModLootOverrides.init();
        if (EXPOSURE_ON) {
            ExposureCompat.init();
        }
        RegHelper.addItemsToTabsRegistration(VistaMod::addItemsToTabs);
        if (PlatHelper.getPhysicalSide().isClient()) {
            VistaModClient.init();
            PlatHelper.addReloadableCommonSetup((ra, dataReload) -> {
                if (!dataReload.booleanValue()) {
                    TapeTextureManager.onWorldReload();
                }
            });
        }
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.add(CreativeModeTabs.REDSTONE_BLOCKS, new ItemLike[]{(ItemLike)TV.get()});
        event.add(CreativeModeTabs.REDSTONE_BLOCKS, new ItemLike[]{(ItemLike)VIEWFINDER.get()});
        CreativeModeTab.ItemDisplayParameters parameters = event.getParameters();
        for (Holder.Reference v : parameters.holders().lookupOrThrow(CASSETTE_TAPE_REGISTRY_KEY).listElements().toList()) {
            if (v.is(SUPPORTER_TAPES)) continue;
            ItemStack stack = CASSETTE.get().getDefaultInstance();
            stack.set(CASSETTE_TAPE_COMPONENT.get(), (Object)v);
            event.add(CreativeModeTabs.TOOLS_AND_UTILITIES, new ItemStack[]{stack});
        }
        event.add(CreativeModeTabs.TOOLS_AND_UTILITIES, new ItemLike[]{(ItemLike)HOLLOW_CASSETTE.get()});
        if (EXPOSURE_ON) {
            // empty if block
        }
    }

    static {
        RegHelper.registerDataPackRegistry(CASSETTE_TAPE_REGISTRY_KEY, CassetteTape.DIRECT_CODEC, CassetteTape.DIRECT_CODEC);
        TV = RegHelper.registerBlock((ResourceLocation)VistaMod.res("television"), () -> new TVBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.COLOR_BROWN).strength(1.5f)));
        TV_ITEM = RegHelper.registerItem((ResourceLocation)VistaMod.res("television"), () -> new TelevisionItem(TV.get(), new Item.Properties()));
        TV_TILE = RegHelper.registerBlockEntityType((ResourceLocation)VistaMod.res("television"), TVBlockEntity::new, (Supplier[])new Supplier[]{TV});
        VIEWFINDER = RegHelper.registerBlockWithItem((ResourceLocation)VistaMod.res("viewfinder"), () -> new ViewFinderBlock(BlockBehaviour.Properties.of().strength(1.5f).noOcclusion()));
        VIEWFINDER_TILE = RegHelper.registerBlockEntityType((ResourceLocation)VistaMod.res("viewfinder"), ViewFinderBlockEntity::new, (Supplier[])new Supplier[]{VIEWFINDER});
        CASSETTE = RegHelper.registerItem((ResourceLocation)VistaMod.res("cassette"), () -> new CassetteItem(new Item.Properties().rarity(Rarity.RARE).stacksTo(1)));
        HOLLOW_CASSETTE = RegHelper.registerItem((ResourceLocation)VistaMod.res("hollow_cassette"), () -> new HollowCassetteItem(new Item.Properties().rarity(Rarity.RARE).stacksTo(1)));
        LINKED_FEED_COMPONENT = RegHelper.registerDataComponent((ResourceLocation)VistaMod.res("linked_feed"), () -> DataComponentType.builder().persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).build());
        CASSETTE_TAPE_COMPONENT = RegHelper.registerDataComponent((ResourceLocation)VistaMod.res("cassette_tape"), () -> DataComponentType.builder().persistent(CassetteTape.CODEC).networkSynchronized(CassetteTape.STREAM_CODEC).build());
        CASSETTE_INSERT_SOUND = RegHelper.registerSound((ResourceLocation)VistaMod.res("block.television.insert"));
        CASSETTE_EJECT_SOUND = RegHelper.registerSound((ResourceLocation)VistaMod.res("block.television.eject"));
        TV_STATIC_SOUND = RegHelper.registerSound((ResourceLocation)VistaMod.res("block.television.static"));
        CASSETTE_TAPE_LOOT_FUNCTION = RegHelper.registerLootFunction((ResourceLocation)VistaMod.res("random_tape"), CassetteTapeLootFunction.CODEC);
        SUPPORTER_TAPES = TagKey.create(CASSETTE_TAPE_REGISTRY_KEY, (ResourceLocation)VistaMod.res("supporter_tapes"));
    }
}

