/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.vista.VistaModClient;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ModRenderTypes
extends RenderType {
    private static final RenderStateShard.ShaderStateShard CAMERA_SHADER_STATE = new RenderStateShard.ShaderStateShard((Supplier)VistaModClient.CAMERA_VIEW_SHADER);
    private static final RenderStateShard.ShaderStateShard STATIC_SHADER_STATE = new RenderStateShard.ShaderStateShard((Supplier)VistaModClient.STATIC_SHADER);
    private static final RenderStateShard.ShaderStateShard POSTERIZE_SHADER_STATE = new RenderStateShard.ShaderStateShard((Supplier)VistaModClient.POSTERIZE_SHADER);
    public static final Function<ResourceLocation, RenderType> CAMERA_DRAW = Util.memoize(text -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(CAMERA_SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(text, false, false)).setTransparencyState(NO_TRANSPARENCY).setLightmapState(LIGHTMAP).setTexturingState(new RenderStateShard.TexturingStateShard("set_texel_size", () -> {
            ShaderInstance shader = VistaModClient.CAMERA_VIEW_SHADER.get();
            shader.safeGetUniform("SpriteDimensions").set(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            ModRenderTypes.setCameraDrawUniforms(shader);
        }, () -> {})).createCompositeState(false);
        return ModRenderTypes.create((String)"camera_view", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    });
    public static final BiFunction<ResourceLocation, Material, RenderType> CAMERA_DRAW_SPRITE = Util.memoize((text, mat) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(CAMERA_SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(text, false, false)).setTransparencyState(NO_TRANSPARENCY).setLightmapState(LIGHTMAP).setTexturingState(new RenderStateShard.TexturingStateShard("set_texel_size", () -> {
            ShaderInstance shader = VistaModClient.CAMERA_VIEW_SHADER.get();
            TextureAtlasSprite sprite = mat.sprite();
            ModRenderTypes.setSpriteDimensions(shader, sprite);
            ModRenderTypes.setCameraDrawUniforms(shader);
        }, () -> {})).createCompositeState(false);
        return ModRenderTypes.create((String)"camera_view", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    });
    public static final RenderType NOISE = ModRenderTypes.create((String)"noise", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(STATIC_SHADER_STATE).setTransparencyState(NO_TRANSPARENCY).setLightmapState(LIGHTMAP).setTexturingState(new RenderStateShard.TexturingStateShard("set_texel_size", () -> {
        ShaderInstance shader = VistaModClient.STATIC_SHADER.get();
    }, () -> {})).createCompositeState(false));
    public static final Function<RenderTarget, RenderType> POSTERIZE = Util.memoize(target -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(POSTERIZE_SHADER_STATE).setTransparencyState(NO_TRANSPARENCY).setCullState(NO_CULL).setTexturingState(new RenderStateShard.TexturingStateShard("set_uniforms", () -> {
            RenderSystem.setShaderTexture((int)0, (int)target.getColorTextureId());
            ShaderInstance shader = VistaModClient.POSTERIZE_SHADER.get();
            shader.safeGetUniform("PostMode").set(1.0f);
            shader.safeGetUniform("PostLevels").set(new Vector3f(25.0f, 20.0f, 20.0f));
            shader.safeGetUniform("FxaaEdge").set(1.0E-4f);
            shader.safeGetUniform("FxaaBlend").set(1.5f);
            shader.safeGetUniform("FxaaDiagonal").set(1.3f);
            shader.safeGetUniform("FxaaSpread").set(1.2f);
            shader.safeGetUniform("DitherScale").set(1.0f);
            shader.safeGetUniform("DitherStrength").set(1.0f);
        }, () -> {})).createCompositeState(false);
        return ModRenderTypes.create((String)"posterize", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    });

    public ModRenderTypes(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
    }

    private static void setSpriteDimensions(ShaderInstance shader, TextureAtlasSprite sprite) {
        shader.safeGetUniform("SpriteDimensions").set(new Vector4f(sprite.getU0(), sprite.getV0(), sprite.getU1() - sprite.getU0(), sprite.getV1() - sprite.getV0()));
    }

    private static void setCameraDrawUniforms(ShaderInstance shader) {
        ModRenderTypes.setFloat(shader, "TriadsPerPixel", 1.37f);
        ModRenderTypes.setFloat(shader, "Smear", 1.0f);
        ModRenderTypes.setFloat(shader, "EnableEnergyNormalize", 0.0f);
        ModRenderTypes.setFloat(shader, "VignetteIntensity", 1.0f);
    }

    private static void setFloat(ShaderInstance shader, String name, float value) {
        shader.safeGetUniform(name).set(value);
    }
}

