/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.vista.VistaMod;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;

public record CassetteTape(ResourceLocation assetId, int color, Optional<Holder<SoundEvent>> soundEvent, Optional<Integer> soundDuration) {
    public static final Codec<CassetteTape> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(CassetteTape::assetId), (App)ColorUtils.CODEC.fieldOf("color").forGetter(CassetteTape::color), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(CassetteTape::soundEvent), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("sound_duration").forGetter(CassetteTape::soundDuration)).apply((Applicative)instance, CassetteTape::new)).validate(obj -> {
        if (obj.soundEvent.isPresent() && !obj.soundDuration.isPresent()) {
            return DataResult.error(() -> "Cassette tapes with sound events must have a sound duration");
        }
        return DataResult.success((Object)obj);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, CassetteTape> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CassetteTape::assetId, (StreamCodec)ByteBufCodecs.VAR_INT, CassetteTape::color, (StreamCodec)ByteBufCodecs.optional((StreamCodec)SoundEvent.STREAM_CODEC), CassetteTape::soundEvent, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), CassetteTape::soundDuration, CassetteTape::new);
    public static final Codec<Holder<CassetteTape>> CODEC = RegistryFileCodec.create(VistaMod.CASSETTE_TAPE_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<CassetteTape>> STREAM_CODEC = ByteBufCodecs.holder(VistaMod.CASSETTE_TAPE_REGISTRY_KEY, DIRECT_STREAM_CODEC);
}

