/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.List;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.VistaModClient;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.mehvahdjukaar.vista.common.ViewFinderConnection;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HollowCassetteItem
extends Item {
    public HollowCassetteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockEntity be = level.getBlockEntity(context.getClickedPos());
        if (be instanceof ViewFinderBlockEntity) {
            ViewFinderBlockEntity feed = (ViewFinderBlockEntity)be;
            if (!level.isClientSide) {
                ItemStack stack = context.getItemInHand();
                stack.set(VistaMod.LINKED_FEED_COMPONENT.get(), (Object)feed.getUUID());
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || stack.get(VistaMod.LINKED_FEED_COMPONENT.get()) != null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        UUID feedId = (UUID)stack.get(VistaMod.LINKED_FEED_COMPONENT.get());
        if (feedId != null && PlatHelper.getPhysicalSide().isClient()) {
            Level level = VistaModClient.getLevel();
            ViewFinderConnection connection = ViewFinderConnection.get(level);
            if (connection == null) {
                return;
            }
            GlobalPos gp = connection.getLinkedFeedLocation(feedId);
            if (gp == null) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.vista.hollow_cassette.linked_unknown").withStyle(ChatFormatting.GRAY));
            } else if (gp.dimension() == level.dimension()) {
                BlockPos pos = gp.pos();
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.vista.hollow_cassette.linked", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.vista.hollow_cassette.linked_away", (Object[])new Object[]{gp.dimension()}).withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

